<script src="//code.jquery.com/jquery-1.11.0.min.js"></script>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
    var googleReCaptchaResponse = null;
    function googleReCaptchaCallback() {
        googleReCaptchaResponse = grecaptcha.getResponse();
        $("#_contact").submit();
    }
    
    function api(data) {
        return $.ajax({
            url: "api.php",
            type: "POST",
            data: data,
            cache: false
        });
    }
    
    $.fn.showLoader = function() {
	    return this.each(function() {
		    $(this).css('position','relative').append('<div class="loader" style="text-align:left;position:absolute;left:0px;top:0px;width:100%;height:100%;background:white;opacity:.65;color:black;font-size:14px;font-weight:bold;">Laden...</div>');
	    });
    };
    $.fn.hideLoader = function() {
	  	return this.each(function() {
		  	$(this).find('.loader').remove();
	  	});
    };

    $(document).ready(function(){

        function hideAll() {
            $('.content > div').not(":eq(.unhide)").fadeOut( "fast", function() {});
        }

        var categorySelect = $("#category");
        var ontvangenDagen = $('#ontvangen_dagen');

		function changeSelect(q) {
			hideAll();
			q = q.replace('_','');
			$("#_"+q).fadeIn( "slow", function() {window.scroll(0,0) ;});
			if ($('[value=' + q + '][data-hide-forms]').length) {
				hideForms();
			} else if (
			    (q=="betalen") ||
                (q=="downloaden") ||
                (q=="inloggen") ||
                (q=="media") ||
                (q=="klacht") ||
                (q=="overige")
            ) {
			    showContactForm(function() {window.scroll(0,0);});
			    hideAfmeldenForm();
            }
            else if (q=="afmelden2") {
                showAfmeldenForm(function() {window.scroll(0,0);});
                $('#_afmelden').hide();
                $('#_afmelden2').show();
                hideContactForm();
            } else {
			    hideForms();
            }
			window.location.hash = '#'+q;
		}

		function showContactForm(callback) {
		    callback = (typeof callback !== 'function') ? function(){} : callback;
            $("#_contact").fadeIn( "slow", callback)
        }

		function showAfmeldenForm(callback) {
		    callback = (typeof callback !== 'function') ? function(){} : callback;
            $("#_formulier_afmelden").fadeIn( "slow", callback)
        }

        function hideForms() {
            hideContactForm();
            hideAfmeldenForm();
        }

        function hideContactForm() {
            $("#_contact").fadeOut( "fast")
        }

        function hideAfmeldenForm() {
            $("#_formulier_afmelden").fadeOut( "fast")
        }

        categorySelect.change(function(){
            changeSelect($(this).val());
        });

        // handle changes in hash
        window.onpopstate = function() {
            var val = document.location.hash.substr(1);
            var option = categorySelect.find('[value=' + val + ']');
            if (option.length && !option[0].selected) {
                categorySelect.val(val);
                categorySelect.change();
            }
        };

        function init() {
            var val = window.location.hash.replace('#','');
            categorySelect.val(val);
            categorySelect.change();
        }
        init();

        $("#_contact").submit(function(e){
            e.preventDefault();
            var selectedCategory = $("#category option:selected");
            var category = selectedCategory.text();
            if (selectedCategory.val() === 'ontvangen') {
                category = category + ' - ' + (ontvangenDagen.val() === 'short' ? '1 tot 3 dagen' : 'meer dan 3 dagen');
            }

            var data = {
                cmd: 'contact',
                name: $("#name").val(),
                email: $("#email").val().split(' ').join(''),
                subject: $("#subject").val(),
                message: $("#message").val(),
                category: category,
                recaptcha_response: googleReCaptchaResponse
            };

            postToApi(data);
		});

        $("#_formulier_afmelden").submit(function(e){
            e.preventDefault();
            var data = {
                cmd: 'afmelden',
                email: $("#email2").val().split(' ').join(''),
                saleId: $("#sale_id").val(),
                recaptcha_response: googleReCaptchaResponse
            };

            postToApi(data);
		});

        function postToApi(data) {
            $.ajax({
                url: "api.php",
                type: "POST",
                data: data,
                cache: false
            })
                .done(function( html ) {
                    if (html == "OK") {
                        document.location.href = location.protocol+'//'+location.host+location.pathname + 'danke/';
                        return;
                    }
                    alert(html);
                })
                .always(function() {
                    // grecaptcha.reset();
                });
        }

		$("#linkruilForm").submit(function(e){
			e.preventDefault();
			var data = $(this).serializeArray();
			data.push({name: 'cmd', value: 'linkruil'});
			$.ajax({
				url: "//senhpayments.nl/contactformulier/ajax-api.php",
				type: "POST",
				data: data,
				cache: false,
				crossDomain: true
			})
			.done(function( html ) {
				if (html == "OK") {
					document.location.href = location.protocol+'//'+location.host+location.pathname + 'danke/';
					return;
				}
				alert(html);
			})
			.always(function() {
                // grecaptcha.reset();
			});

		});

        ontvangenDagen.change(function() {
            setOntvangenDagenTekst();
        });

        if (categorySelect.val() === 'ontvangen') {
            setOntvangenDagenTekst();
        }

        function setOntvangenDagenTekst() {
            var ontvangenDagenTextShort = $('#ontvangen_dagen_text_short');
            var ontvangenDagenTextLong = $('#ontvangen_dagen_text_long');
            ontvangenDagenTextShort.hide();
            ontvangenDagenTextLong.hide();
            switch (ontvangenDagen.val()) {
                case 'short': {
                    ontvangenDagenTextShort.show();
                    showContactForm();
                    break;
                }
                case 'long': {
                    ontvangenDagenTextLong.show();
                    showContactForm();
                    break;
                }
                default: {
                    hideForms();
                }
            }
        }
	});

</script>