<?php

class FluentPDOSenh extends FluentPDO
{

    /**
     * Create SELECT query from $table
     *
     * @param string  $table      - db table name
     * @param integer $primaryKey - return one row by primary key
     *
     * @return \SelectQuerySenh
     */
    public function from($table, $primaryKey = null) {
        $query = new SelectQuerySenh($this, $table);
        if ($primaryKey !== null) {
            $tableTable     = $query->getFromTable();
            $tableAlias     = $query->getFromAlias();
            $primaryKeyName = $this->structure->getPrimaryKey($tableTable);
            $query          = $query->where("$tableAlias.$primaryKeyName", $primaryKey);
        }

        return $query;
    }

    /**
     * @return SelectQuerySenh
     */
    public function createSelectQuery()
    {
        return $this->from('dummy');
    }
}