<?php

class MailerFactory
{
    /**
     * @var Swift_Mailer
     */
    protected $mailer;

    public static function getInstance()
    {
        static $instance = null;
        if ($instance === null) {
            $instance = new static();
        }

        return $instance;
    }

    protected function __construct()
    {
        /**
         * disabled extra parameters, because escapeshellcmd was disabled on server, being called in:
         * \Swift_Transport_MailTransport::_isShellSafe
         */
        $this->mailer = new Swift_Mailer(new Swift_MailTransport(''));
    }

    public function getTransport()
    {
        return $this->mailer->getTransport();
    }

    /**
     * @param Swift_Mailer $mailer
     */
    public function setMailer($mailer)
    {
        $this->mailer = $mailer;
    }

    /**
     * @return Swift_Mailer
     */
    public function getMailer()
    {
        return $this->mailer;
    }
}