<?php

require_once realpath(__DIR__ . '/../') . '/init.php';

$paymentTestMode = defined('PAYMENT_TEST_MODE') && PAYMENT_TEST_MODE === true;

if (isset($_POST['sale_id']) && $_POST['sale_id'] != $_SESSION['sale_id']) {
?><script>alert('Er ging iets fout, probeer het nog eens.');history.go(-1);</script><?php
	die();
}

if (!function_exists('get_sale')) { 
	function get_sale() {
		return $_SESSION['sale'][$_SESSION['sale_id']];
	}
}
//if ($_GET['test']) { print_r(get_sale()); die(); }
//$sale = $_SESSION['sale'];
$sale = get_sale() ?: die();
$sale['IssuerID'] = $sale['IssuerID'] ?: $_POST['IssuerID'];
$sale['name'] = $sale['name'] ?: $_POST['name'];
$sale['email'] = $sale['email'] ?: $_POST['email'];
$sale['payment_system'] = $sale['payment_system'] ?: $_POST['payment_system'];
$sale['iban'] = $_POST['iban'] ? str_replace(' ', '', $_POST['iban']) : null;
$sale['order_quantity'] = isset($_POST['quantity']) ? ($_POST['quantity'] ?: 1) : 1;

// consumer address
$sale['consumer_address'] = $_POST['address'];
$sale['consumer_postal'] = str_replace(' ', '', $_POST['postal']);
$sale['consumer_city'] = $_POST['city'];
$sale['consumer_country'] = $_POST['country'];

// insert fake consumer address when no address has been posted
if (!isset($_POST['address'])) {
	$sale['consumer_address'] = 'Adres 99';
	$sale['consumer_postal'] = '1234AB';
	$sale['consumer_city'] = 'Plaats';

	$ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['REMOTE_ADDR'])));
	$country = @$ipdat->geoplugin_countryName ?: 'unknown';
	$sale['consumer_country'] = $country;
    $is_product_payment = false;
} else {
	// enable product payment when requiring personal data like address for sending a physical product
	$is_product_payment = true;
}

// paypal-termijnen2 is creditcard payment with paypal
if ($sale['payment_system'] == 'paypal-termijnen2') {
	$sale['payment_system'] = 'paypal-termijnen';
}

do_iban_check($sale['iban']);

// override return url onetime when payment methods aren't paypal or ideal
if ($sale['payment_system'] != 'ideal' && $sale['payment_system'] != 'paypal-termijnen' && $sale['payment_system'] != 'mistercash') {
	$sale['return_url_onetime'] = $sale['return_url_onetime2'];
}

// do some product updates
senh_delete_product_subscription($sale['productID']);
senh_update_product($sale['productID'], array(
	'price_c' => $sale['price']*$sale['order_quantity'],
	'affiliate_commission_c' => $sale['aff_comm_onetime']*$sale['order_quantity']
));


// test data
/*$sale['email'] = 'sam@sam.nl';
$sale['payment_system'] = '161';
$sale['name'] = 'sam';*/

$consumer_data = array(
	'name' => $sale['name'], 
	'email' => $sale['email'],
	'accountno' => $sale['iban'],
	'address' => $sale['consumer_address'],
	'postal' => $sale['consumer_postal'],
	'city' => $sale['consumer_city'],
	'country' => $sale['consumer_country'],
	'vat' => isset($is_product_payment) && $is_product_payment == true ? 6 : 21,
	'amount' => $sale['price']*$sale['order_quantity'],
	'order_quantity' => $sale['order_quantity']
);

$postbackUrl = isset($sale['postback_url']) ? $sale['postback_url'] : POSTBACK_URL_DEFAULT;

@require_once('/home/salespages/domains/senhpayments.nl/public_html/abandoning/abandoning.php');
@$abandoning = new abandoning();
@$abandoning->add_abandoning($sale['email'],$sale['name'],$_SERVER["HTTP_HOST"]);
@$abandoning->set_cookie($sale['email'], $sale['productName']);

// override payment_system with issuerid
if ($sale['payment_system'] == 'ideal' || $sale['payment_method'] == 'ideal') {
	$sale['payment_system'] = $sale['IssuerID'] = $sale['IssuerID'] ?: $sale['ideal_issuer'];
}

$pay_method = $sale['payment_system'] ?: $sale['payment_method'];

NextSellHelper::getInstance()->saveCheckoutData($_SESSION['sale_id'], $sale, $consumer_data, $pay_method);


if ($is_product_payment) {
    senh_do_product_payment(
        $sale['productID'],
        $sale['productName'],
        senh_get_paypro_single_pay_method($pay_method),
        $consumer_data, $sale['return_url_onetime'],
        true,
        $postbackUrl,
        $paymentTestMode);
} else {
	senh_do_payment(
        $sale['productID'],
        $sale['productName'],
        senh_get_paypro_single_pay_method($pay_method),
        $consumer_data, $sale['return_url_onetime'],
        true,
        $postbackUrl,
        $paymentTestMode);
}