import React from 'react';

export function Date({question, answerHandler, givenAnswers}) {
    return (
        <input
            type='date'
            name={"question" + question.question_id}
            id={"question" + question.question_id}
            defaultValue={givenAnswers[question.question_id] !== undefined && givenAnswers[question.question_id]}
            onChange={(e) => {
                answerHandler(question.question_id, e.target.value);
            }}
            required
            className="senh-quiz-input"
        />
    );
}

export function EdgeDate({question, answerHandler, givenAnswers}) {
     return (
         <input
             type='text'
             name={"question" + question.question_id}
             id={"question" + question.question_id}
             defaultValue={givenAnswers[question.question_id] !== undefined && givenAnswers[question.question_id] ? givenAnswers[question.question_id] : ''}
             placeholder="dd-mm-jjjj"
             onChange={(e) => {
                 answerHandler(question.question_id, e.target.value);
             }}
             required
             className="senh-quiz-input"
         />
     );
}

export function Radio({question, answerHandler, givenAnswers}) {
    return (
        question.answers.map((answer, index) => (
            <div key={index}>
                <input
                    onChange={(e) => {
                        answerHandler(question.question_id, e.target.value);
                    }}
                    type="radio"
                    value={answer.id}
                    name={"question" + question.question_id}
                    id={"question" + question.question_id + "-a" + answer.id}
                    defaultChecked={givenAnswers[question.question_id] !== undefined && givenAnswers[question.question_id] == answer.id}
                    required
                    className="senh-quiz-input"
                />

                <label htmlFor={"question" + question.question_id + "-a" + answer.id} className="answer-label">{answer.title}</label>
            </div>
        ))
    );
}