<?php
/**
 * Plugin Name: SenhQuiz
 * Description: Senhquiz plugin.
 * Version: 1.0
 * Author: Artitex
 */

use api\WordpressApi;

defined( 'ABSPATH' ) or die( 'Direct script access diallowed.' );
define('SENHQUIZ_PLUGIN_PATH', plugin_dir_path(__FILE__));

require_once('php/init.php');

class senhquiz {

    public function __construct()
    {
        // Add api
        $wordpress_api = new WordpressApi();

        // Add page shortcodes;
        add_shortcode('senhquiz-quiz', [$this, 'view']);
        add_shortcode('senhquiz-bedankt', [$this, 'bedankt']);
    }

    public function add_react() {
        echo '<script src="' . plugins_url() . '/senhquiz/bundle.js"></script>';
    }

    public function view($atts, $content = null) {
        extract(shortcode_atts([
            'paymentpage' => ''
        ], $atts));

        echo '<div data-pay="' . $paymentpage . '" id="payment-page"></div>';
        add_action('wp_footer', [$this, 'add_react']);
        return '<div id="quiz"></div>';
    }

    public function bedankt() {
        add_action('wp_footer', [$this, 'add_react']);
        echo '<div data-token="' . $_GET['token'] . '" id="token"></div>';
        return '<div id="bedankt"></div>';
    }

    public function activation() {
        global $wpdb;
        global $jal_db_version;

        $senhquiz_quiz = "
            CREATE TABLE IF NOT EXISTS {$wpdb->prefix}senhquiz_quiz (
                    quiz_id INT NOT NULL AUTO_INCREMENT,
                    quiz_name VARCHAR(45),
                    PRIMARY KEY (quiz_id)
                );
        ";

        $senhquiz_question = "
            CREATE TABLE IF NOT EXISTS {$wpdb->prefix}senhquiz_question (
                    question_id INT NOT NULL AUTO_INCREMENT,
                    title VARCHAR(200),
                    visible VARCHAR(200),
                    type VARCHAR(200),
                    abbreviation VARCHAR(200),
                    answers TEXT,
                    active TINYINT(1),
                    quiz_id INT,
                    PRIMARY KEY (question_id)
                );
        ";

        $senh_answers = "
            CREATE TABLE IF NOT EXISTS {$wpdb->prefix}senhquiz_answers (
                answer_id INT NOT NULL AUTO_INCREMENT,
                question_id INT,
                answer_title VARCHAR(200),
                answer_long TEXT,
                PRIMARY KEY (answer_id)
            );
        ";

        $senhquiz_submitted = "
            CREATE TABLE IF NOT EXISTS {$wpdb->prefix}senhquiz_submitted (
                    submit_id INT NOT NULL AUTO_INCREMENT,
                    birth DATE,
                    token TEXT,
                    answers TEXT,
                    PRIMARY KEY (submit_id)
                );
        ";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta($senhquiz_quiz);
        dbDelta($senhquiz_question);
        dbDelta($senh_answers);
        dbDelta($senhquiz_submitted);

        add_option( 'jal_db_version', $jal_db_version );
    }

    public function deactivation() {

    }

    public function uninstall() {

    }

}

$senhquiz = new senhquiz();

register_activation_hook(__FILE__, [$senhquiz, 'activation']);