<?php

add_filter('scp_pimper_options', function($options) {
	$options['quote'] = 'Quote';
	return $options;
});

function sharketing_content_pimper_quote($atts, $content) {

	// load template
	if (isset($atts['template_id']) && $atts['template_id']) {
		$quote_templates = scp_get_option('quote_templates') ?: array();
		$the_template = null;
		foreach ($quote_templates as $template) {
			if ($template['template_id'] == $atts['template_id']) {
				$the_template = $template;
				break;
			}
		}
		if ($the_template) {
			$atts = array_merge($the_template, $atts);
		}
	}

	$uid = 'scpquote' . uniqid();

	$quote_style = '<style>';

	$quote_style .= '#' . $uid . ' blockquote{';

	//if (!$atts['icon']) {
	//	$quote_style .= 'padding:14px;';
	//}

	if (isset($atts['width']) && $atts['width']) {
		if (!strpos($atts['width'], 'px') && !strpos($atts['width'], '%')) {
			$atts['width'] .= 'px';
		}
		$quote_style .= 'width:' . $atts['width'] . ';';
	}

	if (isset($atts['text_alignment']) && $atts['text_alignment']) {
		$quote_style .= 'text-align:' . $atts['text_alignment'] . ';';
	}

	if (isset($atts['type']) && $atts['type'] == 'line') {
		$quote_style .= 'border-left:4px solid ' . scp_parse_colorcss($atts['line_color']) . ';';
	}

	if (isset($atts['background_color']) && $atts['background_color']) {
		$quote_style .= 'background-color:' . scp_parse_colorcss($atts['background_color']) . ';';
	}

	if (isset($atts['icon']) && !$atts['icon']) {
		$quote_style .= 'background-image:none;';
	}

	$quote_style .= '}';
	
	/* font style */
	$quote_style .= '#' . $uid . ' p{';

	$quote_style .= 'margin:10px;';

	if (isset($atts['font_color']) && $atts['font_color']) {
		$quote_style .= 'color:' . scp_parse_colorcss($atts['font_color']) . ';';
	}

	if (isset($atts['font_size']) && $atts['font_size']) {
		if ($atts['font_size'][0] == '+') {
			$atts['font_size'] = get_theme_mod('content_fontsize_paragraph') + intval($atts['font_size']);
		}
		$quote_style .= 'font-size:' . $atts['font_size'] . 'px;';
		$quote_style .= 'line-height:1.5em;';
	}

	if (isset($atts['font_italic']) && $atts['font_italic'] == 'yes') {
		$quote_style .= 'font-style:italic;';
	} elseif (isset($atts['font_italic']) && $atts['font_italic'] == 'no') {
		$quote_style .= 'font-style:normal;';
	}

	$quote_style .= '}';
	/***/

	/* quote icon style */
	/*$quote_style .= '#' . $uid . ' blockquote .scp-quote-icon-left, #' . $uid . ' blockquote .scp-quote-icon-right{';
	if ($atts['font_color']) {
		$quote_style .= 'color:' . $atts['font_color'] . ';';
	}
	$quote_style .= '}';*/
	/***/

	$quote_style .= '</style>';

	/*if ($atts['icon']) {
		$quotes = '<i class="fa fa-quote-left scp-quote-icon-left"></i><i class="fa fa-quote-right scp-quote-icon-right"></i>';
		$content = str_replace('</blockquote>', $quotes . '</blockquote>', $content);
	}*/

    if (strpos($content, '<blockquote>')) {
        $content = '<div id="' . $uid . '" class="scp-quote">' . $content . '</div>' . $quote_style;
    } else {
        $content = '<div id="' . $uid . '" class="scp-quote"><blockquote>' . $content . '</blockquote></div>' . $quote_style;
    }

//	$content = '<div id="' . $uid . '" class="scp-quote">' . $content . '</div>' . $quote_style;

	// remove empty lines
	$content = str_replace(array('<p></p>', '<br />', '<p class="scp-code scp-code-start">', '<p class="scp-code scp-code-end">'), '', $content);
	$content = str_replace('"></p>', '">', $content);

	return do_shortcode($content);
}
add_shortcode('quote', 'sharketing_content_pimper_quote');

add_action('admin_enqueue_scripts', function() {
	add_thickbox();
	wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('scp-quote', plugin_dir_url( __FILE__ ) . 'quote.js', array('jquery', 'wp-color-picker'), time());
	wp_enqueue_style('sharketing-content-pimper', plugins_url('style.css', __FILE__));
});

function scp_pimper_option_quote() {
?>
		
	<div>Select quote template: <select id="scp-quote-template-selector"><option></option>
	<?php foreach (scp_get_option('quote_templates') as $quote_template) { if (!$quote_template['active']) continue; ?>
		<option value="<?php echo urlencode(json_encode($quote_template)); ?>" data-quote-template-id="<?php echo $quote_template['template_id']; ?>"><?php echo $quote_template['template_name']; ?></option>
	<?php } ?>
	</select>
	<iframe id="scp-quote-template-example" src="" width="100%" height="250" style="display:none;border:2px solid #cdcdcd;"></iframe>
	</div>

	<div class="show-template-edit show-quote-template-edit">
		Template name: <input type="text" value="" name="scp-quote-template-name" />
		<input type="hidden" value="" name="scp-quote-template-id" />
	</div>

	<div class="show-custom-options-quote-checkbox" style="display:none"><label><input type="checkbox" /> Meer opties</label></div>

	<div class="custom-options-quote" style="display:none">

	<h3>1. Choose quote style</h3>
	<h4 style="margin-bottom:0px;padding-bottom:0px;">Type</h4>
	<div style="float:left;width:30%;"><label><input type="radio" name="scp-quote-type" value="" checked /> (default)</label></div>
	<div style="float:left;width:30%;"><label><input type="radio" name="scp-quote-type" value="line" /> Line</label></div>

	<div style="clear:both;"></div>

	<div style="width:30%;float:left;">
		<h4 style="margin-bottom:0px;padding-bottom:0px;">Line color</h4>
		<div><input type="text" id="scp-quote-line-color-picker" name="scp-quote-line-color-picker" /></div>
	</div>

	<div style="width:30%;float:left;">
		<h4 style="margin-bottom:0px;padding-bottom:0px;">Background color</h4>
		<div><input type="text" id="scp-quote-background-color-picker" name="scp-quote-background-color-picker" /></div>
	</div>

	<div style="clear:both;"></div>

	<h4 style="margin-bottom:0px;padding-bottom:0px;"><input type="checkbox" id="scp-quote-icon" name="scp-quote-icon" checked /> Show quote icon</h4>

	<h4 style="margin-bottom:0px;padding-bottom:0px;">Width (in px or %)</h4>
	<div><input type="text" id="scp-quote-width" name="scp-quote-width" /><select name="scp-quote-width-type"><option>%</option><option>px</option></select></div>



	<h3>2. Select text style</h3>
	<h4 style="margin-bottom:0px;padding-bottom:0px;">Color</h4>
	<div><label><input type="radio" name="scp-quote-font-color" value="" checked /> (default)</label></div>
	<div><input type="radio" name="scp-quote-font-color" value="color_picker" style="margin-top:-20px;" /> <input type="text" id="scp-quote-font-color-picker" name="scp-quote-font-color-picker" /></div>

	<div style="width:40%;float:left;">
		<h4 style="margin-bottom:0px;padding-bottom:0px;">Size</h4>
		<div><select name="scp-quote-font-size">
		<option value="">Same size as normal text</option>
		<option value="+2">2px bigger than normal text</option>
		<option value="+4">4px bigger than normal text</option>
		<option value="+6">6px bigger than normal text</option>
		<option value="+8">8px bigger than normal text</option>
		<option value="+10">10px bigger than normal text</option>
		</select></div>
	</div>

	<div style="width:20%;float:left;">
		<h4 style="margin-bottom:0px;padding-bottom:0px;">Italic</h4>
		<div><select name="scp-quote-font-italic"><option value="">(default)</option><option value="yes" selected>Yes</option><option value="no">No</option></select></div>
	</div>

	<div style="width:30%;float:left;">
		<h4 style="margin-bottom:0px;padding-bottom:0px;">Alignment</h4>
		<div><select name="scp-quote-text-alignment"><option value="">(default)</option><option value="left">Left</option><option value="center" selected>Center</option><option value="right">Right</option></select></div>
	</div>

	<div style="clear:both;"></div>

	<h3>3. Live example</h3>
	<iframe id="scp-quote-example" src="" width="100%" height="250"></iframe>

	</div>

	<input class="button button-primary button-large" id="scp-add-quote-button" value="Add quote" type="button">
	<input class="button button-primary button-large" id="scp-save-quote-button" value="Save quote" type="button" style="display:none">
	<!--<input class="button button-large" id="scp-remove-quote-button" value="Remove quote" type="button" style="margin-left:15px;">-->

	<a id="scp-quote-modal-button" href="#TB_inline?width=600&height=900&inlineId=scp-quote-modal" class="thickbox"></a>
	<script>
		var quote_template;
		(function($) {
			$(document).on('change', '.show-custom-options-quote-checkbox input', function() {
				$('.show-custom-options-quote-checkbox')[$(this).is(':checked') ? 'hide' : 'show']();
				$('.custom-options-quote')[$(this).is(':checked') ? 'show' : 'hide']();
			});

			$('#scp-quote-template-selector').change(function() {
				if (!$(this).val()) {
					quote_template = null;
					$('#scp-quote-template-example').hide();
					$('.custom-options-quote').hide();
					$('.show-custom-options-quote-checkbox').hide();
					$('.show-custom-options-quote-checkbox input').prop('checked', false);
					return;
				}

				$('.custom-options-quote').hide();
				$('.show-custom-options-quote-checkbox').show();
				$('.show-custom-options-quote-checkbox input').prop('checked', false);

				quote_template = JSON.parse(decodeURIComponent($(this).val()));
				
				$('[name="scp-quote-template-id"]').val(quote_template.template_id || '');

				$('[name="scp-quote-type"][value="' + (quote_template.type || '') + '"]').prop('checked', true);
				$('#scp-quote-line-color-picker').val((quote_template.line_color && '#' + quote_template.line_color || '')).trigger('change');
				$('#scp-quote-background-color-picker').val((quote_template.background_color && '#' + quote_template.background_color || '')).trigger('change');
				$('#scp-quote-icon').prop('checked', !!quote_template.icon);
				$('#scp-quote-width').val(parseFloat(quote_template.width) || '');
				$('#scp-quote-width-type').val(quote_template.width ? quote_template.width.substr(-1) : '%');
				$('#scp-quote-font-color[value="' + (quote_template.font_color ? 'color_picker' : '') + '"]').prop('checked', true);
				$('#scp-quote-font-color-picker').val((quote_template.font_color && '#' + quote_template.font_color || '')).trigger('change');
				$('[name="scp-quote-font-size"]').val(quote_template.font_size || '');
				$('[name="scp-quote-font-italic"]').val(quote_template.font_italic || '');
				$('[name="scp-quote-text-alignment"]').val(quote_template.text_alignment || '');

				$('#scp-quote-template-example').show().attr('src', '/wp-content/plugins/sharketing-content-pimper/quote-iframe.php?_before_after_text=0&template_id=' + quote_template.template_id);
			});

			$('#scp-quote-font-color-picker').wpColorPicker({change: function() {
				setTimeout(function() {
					$('[name="scp-quote-font-color"][value="color_picker"').prop('checked', true).trigger('change');
				});
			}});

			$('#scp-quote-line-color-picker').wpColorPicker({change: function() {
				setTimeout(function() {
					$('[name="scp-quote-type"]:checked').trigger('change');
				});
			}});

			$('#scp-quote-background-color-picker').wpColorPicker({change: function() {
				setTimeout(function() {
					$('[name="scp-quote-type"]:checked').trigger('change');
				});
			}});
		})(jQuery);
	</script>
<?php
}
add_action('scp_pimper_option_quote', 'scp_pimper_option_quote');
