jQuery.fn.cleanWhitespace = function() {
    textNodes = this.contents().filter(
        function() { return (this.nodeType == 3 && !/\S/.test(this.nodeValue)); })
        .remove();
    return this;
}

function scp_make_code(label, params) {
	var params_str = '';
	for (var i in params) {
		if (!params[i]) continue;
		params_str += ' ' + i + '="' + params[i] + '"';
	}
	return ['[' + label + params_str + ']', '[/' + label + ']'];
}

function scp_editor_get_selected_nodes() {
	if (tinyMCE && tinyMCE.activeEditor) {
		try
		{
			return jQuery(tinymce.activeEditor.selection.getContent({format: 'html'}));
		}
		catch (r)
		{
			return jQuery(tinymce.activeEditor.selection.getNode());
		}
		
	}
}

function scp_editor_get_node() {
	if (tinyMCE && tinyMCE.activeEditor) {
		return jQuery(tinymce.activeEditor.selection.getNode());		
	}
}

function scp_enclose_editor_selection(start, end) {
	var scrollTop = jQuery(window).scrollTop();

	// is visual or text editor selected?
	if (tinyMCE && tinyMCE.activeEditor) {
		var selected_content_html = tinymce.activeEditor.selection.getContent({format: 'html'});
		var node = jQuery(tinymce.activeEditor.selection.getNode());

		node.cleanWhitespace();
		selected_content_html = jQuery('<div>' + selected_content_html + '</div>').cleanWhitespace().html();

		if (node.html().split(selected_content_html).length != 2) {
			alert('Sharketing Content Pimper says: U should only select whole elements.');
		} else {
			node.html(node.html().split(selected_content_html).join(start + selected_content_html + end));
		}

		/*var node = jQuery(tinymce.activeEditor.selection.getNode());
		jQuery(document.createTextNode(start)).insertBefore(node);
		jQuery(document.createTextNode(end)).insertAfter(node);*/
	} else {
		window.parent.send_to_editor(start + end);
	}

	tb_remove();

	
	// quick hack: update tinymce content
	jQuery('#content-html').click();
	jQuery('#content-tmce').click();

	setTimeout(function() {
		jQuery(window).scrollTop(scrollTop);
	}, 300);
}

function scp_wrap_span_editor_selection(className, extra) {
	var scrollTop = jQuery(window).scrollTop();

	// is visual or text editor selected?
	if (tinyMCE && tinyMCE.activeEditor) {
		var node = jQuery(tinymce.activeEditor.selection.getNode());
		var selected_content_text = tinymce.activeEditor.selection.getContent({format: 'text'});

		if (className && node.hasClass(className)) {
			if (node.text() == selected_content_text) {
				// replace entire node
				node.replaceWith('<span class="' + className + '"' + (extra ? ' ' + extra : '') + '>' + selected_content_text + '</span>');
			} else {
				// replace part of node
				var html = node.html().split(selected_content_text).join('<span class="' + className + '"' + (extra ? ' ' + extra : '') + '>' + selected_content_text + '</span>');
				node.html(html);
			}
		} else {	
			tinymce.activeEditor.selection.setContent('<span class="' + className + '"' + (extra ? ' ' + extra : '') + '>' + selected_content_text + '</span>');
		}

		//jQuery(document.createTextNode(start)).insertBefore(node);
		//jQuery(document.createTextNode(end)).insertAfter(node);
	} else {
		window.parent.send_to_editor(start + end);
	}

	tb_remove();

	
	// quick hack: update tinymce content
	jQuery('#content-html').click();
	jQuery('#content-tmce').click();

	setTimeout(function() {
		jQuery(window).scrollTop(scrollTop);
	}, 300);
}

/*function scp_remove_from_editor_selection(selector) {
	// is visual or text editor selected?
	if (tinyMCE && tinyMCE.activeEditor) {
		var node = jQuery(tinymce.activeEditor.selection.getNode());
		var found = node.closest(selector).first();
		if (found) {
			var parent = found.parent();
			var html = found.html();
			found.replaceWith(html);
		}
	}

	
	// quick hack: update tinymce content
	jQuery('#content-html').click();
	jQuery('#content-tmce').click();
}*/

function scp_set_size_thickbox(w,h) {
    jQuery("#TB_window").animate({
        marginLeft: '-' + parseInt((w / 2), 10) + 'px',
        width: w + 'px',
        height: h + 'px',
        marginTop: '-' + parseInt((h / 2), 10) + 'px'
    });
}

function scp_resize_thickbox() {
	scp_set_size_thickbox(jQuery(window).width()*.6, jQuery(window).height()*.8);
}

function scp_close_thickbox() {
	scp_highlight_codes();
	jQuery('#TB_overlay').click();
}

function scp_button_modal(show_option, allow_back, is_admin) {
	jQuery('#scp-button-modal-button').click();

	if (show_option) {
		scp_button_modal_show_option(show_option);
	}

	if (allow_back !== undefined && !allow_back) {
		jQuery('.scp_pimper_options_back').hide();
	} else {
		jQuery('.scp_pimper_options_back').show();
	}

	jQuery('.show-template-edit').hide();

	if (is_admin) {
		jQuery('#scp-' + show_option + '-template-selector').parent().hide();
		jQuery('.custom-options-' + show_option).show();
	}
}

function scp_button_modal_show_option(option) {
	jQuery('#scp-pimper-options').hide();
	jQuery('[id^="scp-pimper-option-"]').hide();
	jQuery('#scp-pimper-option-' + option).show();
}

function scp_remove_shortcode(html, shortcode) {
	return html.replace(/\[\/?[^\]]+(\]|$)/g, "").split('[/' + shortcode + ']').join('');
}

function scp_remove_template_params(new_params, template_params) {
	for (var i in new_params) {
		if (i == 'template_id') continue;
		if (new_params[i] == template_params[i]) {
			delete new_params[i];
		}
	}
}


function scp_highlight_codes() {
	if (window.tinymce && tinymce.activeEditor) {
		var content = tinymce.activeEditor.getContent({format:'raw'});
		var new_content = jQuery('<div>' + content + '</div>');
		new_content.find('.scp-code').removeClass();
		jQuery.each(scp_codes, function() {
			new_content.find("*:contains(" + this + ")").each(function() {
				if (jQuery(this).children().length == 0) {
					jQuery(this).addClass('scp-code');
				}
			});
			new_content.find("*:contains([" + this + ")").each(function() {
				if (jQuery(this).children().length == 0) {
					jQuery(this).addClass('scp-code-start');
				}
			});
			new_content.find("*:contains([/" + this + ")").each(function() {
				if (jQuery(this).children().length == 0) {
					jQuery(this).addClass('scp-code-end');
				}
			});
		});
		tinymce.activeEditor.setContent(new_content.html(), {format:'raw'});
	}
}

(function($) {

	$(function() {
		scp_resize_thickbox();
	});
	$(window).resize(scp_resize_thickbox);
	//$(document).on('mousedown', '.thickbox', function() {
		//setTimeout(function() {
	//		scp_resize_thickbox();
		//}, 100);
	//});

	$(window).load(function() {
		var tinymce_shortcode_selected;
		if (window.tinymce && tinymce.activeEditor) {
			tinymce.activeEditor.on('keyup mouseup', function(e) {
				var node = jQuery(tinymce.activeEditor.selection.getNode());
				var html = node.html().split('&nbsp;').join(' ');
				if (html.substr(0,1) == '['/* && html.substr(-1,1) == ']'*/) {
					html = html.substr(1).substr(0,html.length-2);
					var shortcode = {
						'fn': html.split(']').join(' ').split(' ')[0],
						'params': {},
						'params_length': 0
					};
					var params = html.match(/[\w-]+="[^"]*"/g);
					for (var i in params) {
						var part = params[i].split('"').join('').split('=');
						shortcode.params[part[0]] = part[1];
						shortcode.params_length++;
					}
					tinymce_shortcode_selected = tinymce.activeShortcode = shortcode;
					$(window).trigger('tinymce_shortcode_focus', tinymce_shortcode_selected);
				} else if (tinymce_shortcode_selected) {
					$(window).trigger('tinymce_shortcode_blur', tinymce_shortcode_selected);
					tinymce_shortcode_selected = tinymce.activeShortcode = null;
				}
			});

			scp_highlight_codes();
		}
	});
	
	$(window).load(function() {
		if (window.tinymce && tinymce.activeEditor) {
			tinymce.activeEditor.on('keyup mouseup', function(e) {
				var node = tinymce.activeEditor.selection.getNode();
				$(window).trigger('tinymce_element_focus', node, (node.tagName + '').toUpperCase());
			});
		}
	});
	
	$(window).on('tinymce_shortcode_focus', function(e, shortcode) {
		var arr = ['colorbox', 'list', 'column', 'quote', 'scptable'];
		if (arr.indexOf(shortcode.fn) > -1) {
			$('#scp-button-media-button-edit').show();
			$('#scp-button-media-button').hide();
		} else {
			$('#scp-button-media-button').show();
			$('#scp-button-media-button-edit').hide();
		}
		$('#scp-button-media-button-edit').data('tinymce_shortcode_selected', shortcode);
	});
	$(window).on('tinymce_shortcode_blur', function(e, shortcode) {
		$('#scp-button-media-button').show();
		$('#scp-button-media-button-edit').hide();
	});
	$(document).on('click', '#scp-button-media-button-edit', function(e) {
		e.preventDefault();
		scp_button_modal($(this).data('tinymce_shortcode_selected').fn, false);
		window['scp_' + $(this).data('tinymce_shortcode_selected').fn + '_modal_fill']($(this).data('tinymce_shortcode_selected').params, $(tinymce.activeEditor.selection.getNode()));
	});


	$(document).on('click', '#scp-button-media-button', function(e) {
		e.preventDefault();
		scp_button_modal();
	});

	$(document).on('click', '[data-scp-pimper-option]', function() {
		scp_button_modal_show_option($(this).data('scp-pimper-option'));
	});

	$(document).on('click', '.scp_pimper_options_back', function() {
		$('[id^="scp-pimper-option-"]').hide();
		$('#scp-pimper-options').show();
	});
	
	$(document).on('mousedown', '#scp-button-modal-content .wp-color-result, .use_senhtheme_colors .wp-color-result', function(e) {
		if ($(this).data('colors-extended')) return;
		$(this).data('colors-extended', true);

		$(this).parent().find('.wp-picker-holder .iris-picker').height(300);

		var html = '';
		for (var i in window.scp_senhteme_famous_colors) {
			html += '<a onclick="$(this).closest(\'.wp-color-picker\').val($(this).data(\'color\');" data-color="' + i + '" style="margin-top:5px;background-color: ' + i + '; height: 19.5784px; width: 19.5784px; margin-left: 3.6px;" class="iris-palette" tabindex="0"></a>';
		}

		var $pc = $(this).parent().find('.wp-picker-holder .iris-palette-container');
		$pc.css('bottom', $pc.outerHeight()+10).append('<hr style="margin-top:25px;"><div style="clear:both;">Reeds gekozen kleuren:</div>' + html);
	});


	function scp_colorbox_modal_fill(colorbox_template) {
		jQuery('[name="scp-colorbox-template-name"]').val(colorbox_template.template_name);
		jQuery('[name="scp-colorbox-template-id"]').val(colorbox_template.template_id);

		jQuery('[name="scp-colorbox-bordercolor-picker"]').val(colorbox_template.border_color).trigger('change');
		jQuery('[name="scp-colorbox-backgroundcolor-picker"]').val(colorbox_template.background_color).trigger('change');
		jQuery('[name="scp-colorbox-fontcolor-picker"]').val(colorbox_template.font_color).trigger('change');

		var width = colorbox_template.width;
		if (width) {
			var real_width = parseInt(width);
			var width_type = width.split(real_width)[1];

			jQuery('[name="scp-colorbox-width"]').val(real_width);
			jQuery('[name="scp-colorbox-width-type"]').val(width_type || '%');
		}
		
		jQuery('[name="scp-colorbox-text-alignment"]').val(colorbox_template.text_alignment);

		jQuery('[name="scp-colorbox-addheader"]').prop('checked', colorbox_template.add_header).trigger('change');

		//jQuery('[name="scp-colorbox-headertext"]').val(colorbox_template.header_text);
		jQuery('[name="scp-colorbox-headercolor-picker"]').val(colorbox_template.header_color).trigger('change');
		jQuery('[name="scp-colorbox-headerfontcolor-picker"]').val(colorbox_template.header_font_color).trigger('change');
		jQuery('[name="scp-colorbox-headertext-alignment"]').val(colorbox_template.header_text_alignment || 'center');
		jQuery('[name="scp-colorbox-headertext-type"]').val(colorbox_template.header_text_type);
		jQuery('[name="scp-colorbox-headerbold"]').prop('checked', !!colorbox_template.header_text_bold);


		jQuery('[name="scp-colorbox-addcircle"]').prop('checked', !!colorbox_template.circle_text).trigger('change');

		jQuery('[name="scp-colorbox-circletext"]').val(colorbox_template.circle_text);
		jQuery('[name="scp-colorbox-circlecolor-picker"]').val(colorbox_template.circle_color).trigger('change');
		jQuery('[name="scp-colorbox-circlefontcolor-picker"]').val(colorbox_template.circle_font_color).trigger('change');
		jQuery('[name="scp-colorbox-circlefontsize"]').val(colorbox_template.circle_font_size);

		if (!jQuery('[data-template-id="' + colorbox_template.template_id + '"]').is(':selected')) {
			jQuery('[data-template-id="' + colorbox_template.template_id + '"]').prop('selected', true).parent().trigger('change');		
		}
	}
	window.scp_colorbox_modal_fill = scp_colorbox_modal_fill;

	function scp_list_modal_fill(obj) {
		jQuery('[name="scp-list-icon-option"][value="' + obj.icon + '"]').prop('checked', true);
		if (jQuery('[name="scp-list-icon-color"][value="' + obj.icon_color.substr(1) + '"]').length == 1) {
			jQuery('[name="scp-list-icon-color"][value="' + obj.icon_color + '"]').prop('checked', true);
		} else {
			jQuery('[name="scp-list-icon-color"][value="color_picker"]').prop('checked', true);
			jQuery('[name="scp-list-icon-color-picker"]').val(obj.icon_color).trigger('change');
		}
	}
	window.scp_list_modal_fill = scp_list_modal_fill;
	
	function scp_scptable_modal_fill(obj, node) {
		jQuery('#scp-table-template-selector [data-quote-template-id="' + obj.template_id + '"]').prop('checked', true);
		
		var table = node.next('table');
		jQuery('#scp-table-rows').val(table.find('tbody > tr').length);
		jQuery('#scp-table-columns').val(table.find('tbody > tr').first().find('td').length);
		jQuery('#scp-table-seperator').prop('checked', !!obj.seperator);
		
		scp_update_table_size(jQuery('#scp-table-rows').val(), jQuery('#scp-table-columns').val());
		scp_update_table_content(scp_get_table_content(table));

	}
	window.scp_scptable_modal_fill = scp_scptable_modal_fill;

	

})(jQuery);