<?php
/*
Plugin Name: Sharketing Dynamic Post Date
Plugin URI: http://sharketing.nl/
Description: Specify for blogposts if and when you want to show the published date and or modified date. Also specify this for categories, tags and more.
Author: sharketing
Version: 2.0.1
Author URI: http://sharketing.nl/?mdpd
*/

if (!class_exists('mdpdLoader')) {

	class mdpdLoader{
		
		function __construct(){
			$this->load_options();
			if (is_admin()) {	
				require_once(dirname (__FILE__) . '/admin.php');
				$this->mdpdAdminPanel = new mdpdAdminPanel();
			} else {
				add_filter('dynamic_post_date_metadata_icons', array(&$this, 'parse_metadata_icons'));
				add_filter('get_the_date', array(&$this, 'give_the_date'));
				add_filter('get_the_modified_date', array(&$this, 'give_the_modified_date'));
				add_filter('get_comment_date', array(&$this, 'give_comment_date'));
			}
			add_action('add_meta_boxes', array(&$this, 'add_post_widget'));
			add_action('save_post', array(&$this, 'save_post_widget'));
			register_activation_hook(__FILE__, array(&$this, 'install'));
			
			// register filters for plugin seo yoast, so we can choose to show or hide HTML meta-elements
			$this->register_filters_wpseo();

			if ($this->get_option('hide_date_item_review_box_rich_snippets_plugin')) {
				// review snippet
				$bsf_review = get_option('bsf_review');
				if (isset($bsf_review['review_date'])) {
					$bsf_review['_review_date'] = $bsf_review['review_date'];
					unset($bsf_review['review_date']);
					update_option('bsf_review', $bsf_review);
				}

				// recipe snippet
				$bsf_recipe = get_option('bsf_recipe');
				if (isset($bsf_recipe['recipe_pub'])) {
					$bsf_recipe['_recipe_pub'] = $bsf_recipe['recipe_pub'];
					unset($bsf_recipe['recipe_pub']);
					update_option('bsf_recipe', $bsf_recipe);
				}
			} else {
				// review snippet
				$bsf_review = get_option('bsf_review');
				if (!isset($bsf_review['review_date']) && isset($bsf_review['_review_date'])) {
					$bsf_review['review_date'] = $bsf_review['_review_date'];
					update_option('bsf_review', $bsf_review);
				}

				// recipe snippet
				$bsf_recipe = get_option('bsf_recipe');
				if (!isset($bsf_recipe['recipe_pub']) && isset($bsf_review['_recipe_pub'])) {
					$bsf_recipe['recipe_pub'] = $bsf_recipe['_recipe_pub'];
					update_option('bsf_recipe', $bsf_recipe);
				}
			}
		}

		function load_options(){
			$this->options = get_option('mdpd_options');
		}

		function save_options(array $options = null) {
			update_option('mdpd_options', $options ?: $this->options);
		}

		function get_option($option) {
			return $this->options[$option];
		}

		function set_option($option, $val) {
			$this->options[$option] = $val;
			$this->save_options();
		}

		function parse_metadata_icons($content) {
			$icons = explode(',', $content);

			// no date metadata found
			if (array_search('date', $icons) === false) return $content;

			$post = $this->get_the_post();

			$showPublishedDate = $this->is_published_post_date_visible($post);
			$showModifiedDate = $this->is_modified_post_date_visible($post);
			if (!$showModifiedDate) {
				//array_unshift($icons, 'mdate');
				$pmdate = array_search('mdate', $icons);
				if ($pmdate !== false) unset($icons[$pmdate]);
			} else if (array_search('mdate', $icons) === false) {
				if (array_search('date', $icons) !== false) {
					array_splice($icons, array_search('date', $icons), 0, array('mdate'));
				} else {
					array_unshift($icons, 'mdate');
				}
			}
			if (!$showPublishedDate) {
				//array_unshift($icons, 'date');
				$pdate = array_search('date', $icons);
				if ($pdate !== false) unset($icons[$pdate]);
			}
			$content = implode(',', $icons);
			
			return $content;
		}

		function give_the_date($content) {
			if (in_the_loop() && $this->is_modified_post_date_visible($this->get_the_post())) {
				$content = 'Geplaatst: ' . $content;
			}
			return $content;
		}

		function give_the_modified_date($content) {
			if ($this->is_visible_custom_date($this->get_the_post())) {
				$content = get_post_meta($this->get_the_post()->ID, 'mdpd_custom_date_text', true);
				if ($content) $content .= ' ';
				$month = get_post_meta($this->get_the_post()->ID, 'mdpd_custom_date_month', true);
				$day = get_post_meta($this->get_the_post()->ID, 'mdpd_custom_date_day', true);
				$year = get_post_meta($this->get_the_post()->ID, 'mdpd_custom_date_year', true);
				$content .= date_i18n(get_option('date_format'), strtotime($day . ' ' . $month . ' ' . $year));
				return $content;
			}
			if (in_the_loop()) {
				$content = 'Laatst bijgewerkt: ' . $content;
			}
			return $content;
		}

		function is_visible_custom_date($post) {
			return strpos(get_post_meta($this->get_the_post()->ID, 'mdpd_visibility_post_date', true), 'Custom') !== false;		
		}

		function get_visible_option() {
			// define visible by option name, chosen by type of structur of post/page
			if (is_tag() || is_search()) {
				$visibleOption = 'visibility_tag_pages_date';
			} else if (is_category()) {
				$visibleOption = 'visibility_category_pages_date';
			} else if (is_singular()) {
				$visibleOption = 'visibility_post_date';
			} else {
				$visibleOption = 'visibility_blog_pages_date';
			}
			return $visibleOption;
		}

		function is_published_post_date_visible($post) {
			$visibleOption = $this->get_visible_option();
			$visible = strpos($this->get_option($visibleOption), 'Published') !== false;

			// only by single post
			if ($visible /*&& is_singular()*/ && $this->get_option('hide_published_post_date') != 'Never Hide') {
				$textDate = $this->get_option('hide_published_post_date');
				if ($textDate == 'The Beginning of Current Year') {
					$visibleDate = mktime(0, 0, 0, 1, 1, date('Y'));
				} else if ($textDate == 'The Beginning of Last Year') {
					$visibleDate = mktime(0, 0, 0, 1, 1, date('Y') - 1);
				} else if ($textDate == 'The Beginning of 2 Years Ago') {
					$visibleDate = mktime(0, 0, 0, 1, 1, date('Y') - 2);
				} else {
					$visibleDate = strtotime('-' . $textDate);
				}
				if (strtotime($post->post_date) < $visibleDate) {
					$visible = false;
				}
			}
			// override with option set in post widget
			$override_option = get_post_meta($post->ID, 'mdpd_visibility_post_date', true);
			if (strpos($override_option, 'Published') !== false) {
				$visible = true;
			} else if ($override_option == 'Hide Date' || ($override_option && strpos($override_option, 'Current') === false)) {
				$visible = false;
			} else if ($this->is_last_post_to_old()) {
				$visible = false;
			}

			// opdr B: there is no reason to force showing the published date when article contains rating stars
			// opdr 107: never hide published date when article contains rich snippets rating stars
			// for efficiency purposes, only do this check when published date IS NOT visible (otherwise this check is useless)
			/*if (!$visible && $this->get_option('never_hide_published_date_with_rating_stars')) {
				if (strpos(apply_filters('the_content', get_the_content()), "itemprop='dtreviewed'") !== false) {
					return true;
				}
			}*/

			return $visible;
		}

		function is_modified_post_date_visible($post) {
			$visibleOption = $this->get_visible_option();
			$visible = strpos($this->get_option($visibleOption), 'Modified') !== false;	
			
			// only by single post
			if ($visible /*&& is_singular()*/ && $this->get_option('hide_modified_post_date') != 'Never Hide') {
				$textDate = $this->get_option('hide_modified_post_date');
				if ($textDate == 'The Beginning of Current Year') {
					$visibleDate = mktime(0, 0, 0, 1, 1, date('Y'));
				} else if ($textDate == 'The Beginning of Last Year') {
					$visibleDate = mktime(0, 0, 0, 1, 1, date('Y') - 1);
				} else if ($textDate == 'The Beginning of 2 Years Ago') {
					$visibleDate = mktime(0, 0, 0, 1, 1, date('Y') - 2);
				} else {
					$visibleDate = strtotime('-' . $textDate);
				}
				if (strtotime($post->post_date) < $visibleDate) {
					$visible = false;
				}
			}
			
			// override with option set in post widget
			$override_option = get_post_meta($post->ID, 'mdpd_visibility_post_date', true);
			if (strpos($override_option, 'Modified') !== false || $this->is_visible_custom_date($post)) {
				$visible = true;
			} else if ($override_option == 'Hide Date' || ($override_option && strpos($override_option, 'Current') === false)) {
				$visible = false;
			} else if ($this->is_last_post_to_old()) {
				$visible = false;
			}
			return $visible;
		}

		function give_comment_date($content) {
			// first check if the comment dates should be visible at all, when not, hide dates (for all comments)
			if ($this->get_option('hide_all_dates_comments_when_specified')) {
				$args = array(
				//	'status' => 'approve',
					'post_id' => $this->get_the_post()->ID
				);
				$comments = get_comments($args);
				foreach ($comments as $comment) {
					// when only one(1) comment date isn't visible, hide the date (for all comments)
					if ($this->is_comment_date_visible($comment)) {
						return false;
					}
				}
			}

			if ($this->is_comment_date_visible(get_comment(get_comment_ID()))) {
				return $content;
			}
		}

		function is_comment_date_visible($comment) {
			$visible = $this->get_option('visibility_comments_date') == 'Show Date';
			if ($visible && $this->get_option('hide_comments_date') != 'Never Hide') {
				$textdate = $this->get_option('hide_comments_date');
				if (strtotime('+' . $textdate, strtotime($comment->comment_date)) < time()) {
					$visible = false;
				}
			}
			return $visible;
		}

		function is_last_post_to_old() {

			// first check if this function (below) should be executed
			if (is_tag() || is_search()) {
				$option = 'hide_all_dates_tagsearch_when_specified';
			} else if (is_category()) {
				$option = 'hide_all_dates_category_when_specified';
			} else if (is_singular()) {
				return null;
			} else {
				$option = 'hide_all_dates_blog_when_specified';
			}
			if (!$this->get_option($option)) return null;


			// should be in the loop for checking if de last post is old
			if (!in_the_loop()) return false;

			if (!isset($this->lastPostDate)) {
				$last_post_date = null;
				global $wp_query;
				foreach ($wp_query->posts as $post) {//if ($_GET['test']) echo '['.$post->post_date . ']<br>';
					//if ($post->post_date && strtotime($post->post_date) < $last_post_date) {
						$last_post_date = strtotime($post->post_date);						
					//}
				}			
				$this->lastPostDate = $last_post_date;
				//if ($_GET['test']) echo '-['.date('d/m/Y', $this->lastPostDate) . ']<br>';
			} else {
				$last_post_date = $this->lastPostDate;
			}

			if ($last_post_date) {
				if (is_tag() || is_search()) {
					$option = 'hide_tag_pages_date_after_last_post';
				} else if (is_category()) {
					$option = 'hide_category_pages_date_after_last_post';
				} else if (is_singular()) {
					return false;
				} else {
					$option = 'hide_blog_pages_date_after_last_post';
				}

				$textDate = $this->get_option($option);
				if ($textDate != 'Never Hide') {
					if ($textDate == 'The Beginning of Current Year') {
						$visibleDate = mktime(0, 0, 0, 1, 1, date('Y'));
					} else if ($textDate == 'The Beginning of Last Year') {
						$visibleDate = mktime(0, 0, 0, 1, 1, date('Y') - 1);
					} else if ($textDate == 'The Beginning of 2 Years Ago') {
						$visibleDate = mktime(0, 0, 0, 1, 1, date('Y') - 2);
					} else {
						$visibleDate = strtotime('-' . $textDate);
					}
					if ($last_post_date < $visibleDate) {
						return true;
					}
				}
			}
		}

		function register_filters_wpseo() {
			$dpd = $this;

			add_filter('wpseo_og_article_published_time', function($content) use ($dpd) {
				$hasReview = $dpd->get_option('never_hide_published_date_with_rating_stars') && strpos(apply_filters('the_content', get_the_content()), "itemprop='dtreviewed'") !== false;
				// HTML meta-element will be hidden when empty string is returned
				return !$hasReview && $dpd->get_option('hide_og_property_article_published_time') && !$dpd->is_published_post_date_visible($dpd->get_the_post()) ? '' : $content;
			});

			add_filter('wpseo_og_article_modified_time', function($content) use ($dpd) {
				// HTML meta-element will be hidden when empty string is returned
				return $dpd->get_option('hide_og_property_article_modified_time') && !$dpd->is_modified_post_date_visible($dpd->get_the_post()) ? '' : $content;
			});

			add_filter('wpseo_og_og_updated_time', function($content) use ($dpd) {
				// HTML meta-element will be hidden when empty string is returned
				return $dpd->get_option('hide_og_property_og_updated_time') && !$dpd->is_modified_post_date_visible($dpd->get_the_post()) ? '' : $content;
			});
		}

		function add_post_widget() {
			add_meta_box(
				'magnate-dynamic-post-date-widget',
				__('Sharketing Dynamic Post Date', 'myplugin_textdomain'),
				array(&$this, 'post_widget_callback'),
				'post'
			);
		}

		function post_widget_callback($post) {
			$value = get_post_meta($post->ID, 'mdpd_visibility_post_date', true);

			echo '<label for="mdpd_visibility_post_date">';			
			_e('Custom Visibility Post Date: ', 'myplugin_textdomain');

			$this->basicSet('mdpd_visibility_post_date', array('Current general setting', 'Show Published Date', 'Show Modified Date', 'Show Published & Modified Date', 'Show Custom Date', 'Show Published & Custom Date', 'Hide Date'), $value);		

			echo '</label>';

			echo '<div><label style="margin-top:6px;">';			
			_e('Custom Date: ', 'myplugin_textdomain');
			echo '<input type="text" id="mdpd_custom_date_text" placeholder="Text before date" name="mdpd_custom_date_text" value="' . get_post_meta($post->ID, 'mdpd_custom_date_text', true) . '" />';
			echo '</label> ';

			$monthsArr = array();
			for ($i = 1; $i <= 12; $i++) $monthsArr[$i] = date_i18n('F', mktime(0, 0, 0, $i, 10));
			echo $this->basicSet('mdpd_custom_date_month', $monthsArr, get_post_meta($post->ID, 'mdpd_custom_date_month', true));

			$daysArr = array();
			for ($i = 1; $i <= 31; $i++) $daysArr[$i] = $i;
			echo $this->basicSet('mdpd_custom_date_day', $daysArr, get_post_meta($post->ID, 'mdpd_custom_date_day', true));

			$yearsArr = array();
			for ($i = date('Y'); $i >= date('Y') - 2; $i--) $yearsArr[$i] = $i;
			echo $this->basicSet('mdpd_custom_date_year', $yearsArr, get_post_meta($post->ID, 'mdpd_custom_date_year', true));
			
			echo '</div>';
			

			?>
			<script>
			jQuery(function() {
				jQuery('[name="mdpd_visibility_post_date"]').change(function() {
					if (jQuery(this).val().indexOf('Custom Date') > -1) {
						jQuery('#mdpd_custom_date_text').parent().parent().show();
					} else {
						jQuery('#mdpd_custom_date_text').parent().parent().hide();
					}
				}).trigger('change');
			});
			</script>
			<?php
		}

		function save_post_widget($post_id) {
			if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
				return;
			}

			if (!current_user_can('edit_post', $post_id)) {
				return;
			} 
			
			if(isset($_POST['mdpd_visibility_post_date'])){
			
				$my_data = sanitize_text_field($_POST['mdpd_visibility_post_date']);
				update_post_meta($post_id, 'mdpd_visibility_post_date', $my_data);
			}
			
			foreach (array('mdpd_custom_date_text', 'mdpd_custom_date_month', 'mdpd_custom_date_day', 'mdpd_custom_date_year') as $name) {
				$data = sanitize_text_field($_POST[$name]);
				update_post_meta($post_id, $name, $data);
			}
		}

		function get_the_post() {
			return get_post(get_the_ID() ?: $_GET['post']);
		}

		function install() {
			if (!$this->options || count($this->options) == 0) {
				$this->options = array(
					'visibility_post_date' => 'Show Published Date',
					'hide_published_post_date' => 'Never Hide',
					'hide_modified_post_date' => 'Never Hide',
					'visibility_comments_date' => 'Show Date',
					'hide_comments_date' => 'Never Hide',
					'visibility_blog_pages_date' => 'Show Published Date',
					'visibility_category_pages_date' => 'Show Published Date',
					'visibility_tag_pages_date' => 'Show Published Date',
					'never_hide_published_date_with_rating_stars' => 1
				);
				$this->save_options();
			}
		}

		function basicSet($name,$set,$numsel) {
			echo "<select name='$name' size=1>";
			foreach ($set as $i) {
				echo '<option ';
				if ($numsel == $i) {echo 'selected="SELECTED" ';
				}
				echo ">".$i."</option>";
			}
			echo "</select>";
		}

		function show_error($message) {
			echo '<div class="wrap"><h2></h2><div class="error" id="error"><p>' . $message . '</p></div></div>' . "\n";
		}
		
		function show_message($message) {
			echo '<div class="wrap"><h2></h2><div class="updated fade" id="message"><p>' . $message . '</p></div></div>' . "\n";
		}
	
	}
	//Start Loader
	global $mdpdLoader;
	$mdpdLoader = new mdpdLoader();
}