<?php 
if(preg_match('#' . basename(__FILE__) . '#', $_SERVER['PHP_SELF'])) { die('You are not allowed to call this page directly.'); }

$mdpd = $mdpdLoader;

if (count($_POST) > 0) {
	if ($error = $mdpd->mdpdAdminPanel->save_options($_POST, explode(',', stripslashes($_POST['_pageOptions'])))) {
		$mdpd->show_error(__($error,'mwmall'));
	} else {
		$mdpd->show_message(__('Updated Successfully','mwmall'));
	}
}



function t($str) {
	return _e($str, 'mdpd');
}

$dateset = array(
	'Never Hide',
	'The Beginning of Current Year',
	'The Beginning of Last Year',
	'The Beginning of 2 Years Ago',
	'1 Month'
);
for ($i = 2; $i <= 24; $i++) {
	$dateset []= $i . ' Months';
}

$dataset_visibility_date = array('Show Published Date', 'Show Modified Date', 'Show Published & Modified Date', 'Hide Date');
  
?>
	
		
<div class="wrap">
	<h2>Sharketing Dynamic Post Date Options</h2>

	<form name="generaloptions" method="post">
		<?php wp_nonce_field('ngg_settings') ?>

		<div id="tab-feedback">
		
			<h3 style="margin-bottom:0px">Posts</h3>
			<table class="form-table">
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Visibility Post Date') ?>:</b> <?php $mdpd->basicSet('visibility_post_date', $dataset_visibility_date, $mdpd->get_option('visibility_post_date')); ?></td>
				</tr>				
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Hide Published Post Date After') ?>:</b> <?php $mdpd->basicSet('hide_published_post_date', $dateset, $mdpd->get_option('hide_published_post_date')); ?></td>
				</tr>
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Hide Modified/Custom Post Date After') ?>:</b> <?php $mdpd->basicSet('hide_modified_post_date', $dateset, $mdpd->get_option('hide_modified_post_date')); ?></td>
				</tr>
			</table>

			<h3 style="margin-bottom:0px">Comments</h3>
			<table class="form-table">
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Visibility Comments Date') ?>:</b> <?php $mdpd->basicSet('visibility_comments_date', array('Show Date', 'Hide Date'), $mdpd->get_option('visibility_comments_date')); ?></td>
				</tr>
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Hide Comments Date After') ?>:</b> <?php $mdpd->basicSet('hide_comments_date', $dateset, $mdpd->get_option('hide_comments_date')); ?></td>
				</tr>
				<tr>
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="hide_all_dates_comments_when_specified" <?php checked($mdpd->get_option('hide_all_dates_comments_when_specified')); ?> /> Hide all dates of comments if one of them is older then you specified above</td>
				</tr>
			</table>

			<h3 style="margin-bottom:0px">Blog Pages</h3>
			<table class="form-table">
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Visibility Blog Pages Date') ?>:</b> <?php $mdpd->basicSet('visibility_blog_pages_date', $dataset_visibility_date, $mdpd->get_option('visibility_blog_pages_date')); ?></td>
				</tr>
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Hide the Blog Page Date after the Last Post is Older Then') ?>:</b> <?php $mdpd->basicSet('hide_blog_pages_date_after_last_post', $dateset, $mdpd->get_option('hide_blog_pages_date_after_last_post')); ?></td>
				</tr>
				<tr>
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="hide_all_dates_blog_when_specified" <?php checked($mdpd->get_option('hide_all_dates_blog_when_specified')); ?> /> Hide all dates of the blog page if one of the posts on the first page of the blog is older then you specified above</td>
				</tr>
			</table>

			<h3 style="margin-bottom:0px">Category Pages</h3>
			<table class="form-table">
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Visibility Category Pages Date') ?>:</b> <?php $mdpd->basicSet('visibility_category_pages_date', $dataset_visibility_date, $mdpd->get_option('visibility_category_pages_date')); ?></td>
				</tr>
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Hide the Category Page Date after the Last Post is Older Then') ?>:</b> <?php $mdpd->basicSet('hide_category_pages_date_after_last_post', $dateset, $mdpd->get_option('hide_category_pages_date_after_last_post')); ?></td>
				</tr>
				<tr>
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="hide_all_dates_category_when_specified" <?php checked($mdpd->get_option('hide_all_dates_category_when_specified')); ?> /> Hide all dates of a category page if one of the posts on the first page of the category is older then you specified above</td>
				</tr>
			</table>

			<h3 style="margin-bottom:0px">Tag & Search Pages</h3>
			<table class="form-table">
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Visibility Tag & Search Pages Date') ?>:</b> <?php $mdpd->basicSet('visibility_tag_pages_date', $dataset_visibility_date, $mdpd->get_option('visibility_tag_pages_date')); ?></td>
				</tr>
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><b><?php t('Hide the Tag & Search Page Date after the Last Post is Older Then') ?>:</b> <?php $mdpd->basicSet('hide_tag_pages_date_after_last_post', $dateset, $mdpd->get_option('hide_tag_pages_date_after_last_post')); ?></td>
				</tr>
				<tr>
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="hide_all_dates_tagsearch_when_specified" <?php checked($mdpd->get_option('hide_all_dates_tagsearch_when_specified')); ?> /> Hide all dates of a tag or search page if one of the posts on the first tag/result page is older then you specified above</td>
				</tr>
			</table>

			<h3 style="margin-bottom:0px">SEO Meta Options</h3>
			<table class="form-table">
				<tr  valign="top">
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="hide_og_property_article_published_time" <?php checked($mdpd->get_option('hide_og_property_article_published_time')); ?> /> Hide the "article:published_time" in the source code of a post</td>
				</tr>
				<tr>
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="hide_og_property_article_modified_time" <?php checked($mdpd->get_option('hide_og_property_article_modified_time')); ?> /> Hide the "article:modified_time" in the source code of a post</td>
				</tr>
				<tr>
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="hide_og_property_og_updated_time" <?php checked($mdpd->get_option('hide_og_property_og_updated_time')); ?> /> Hide the "og:updated_time" in the source code of a post</td>
				</tr>
				<!-- opdr b <tr>
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="never_hide_published_date_with_rating_stars" <?php checked($mdpd->get_option('never_hide_published_date_with_rating_stars')); ?> /> Never hide the published date for articles with rich snippets rating stars</td>
				</tr>-->
				<tr>
					<td scope="row" valign="top" align="left"><input type="checkbox" value="1" name="hide_date_item_review_box_rich_snippets_plugin" <?php checked($mdpd->get_option('hide_date_item_review_box_rich_snippets_plugin')); ?> /> Hide the date in the item review box below an article of the All In One Schema.org Rich Snippets plugin</td>
				</tr>
			</table>

		</div>

		<div id="saveButton" class="submit"><input class="button-primary" type="submit" name="" value="<?php _e('Save Changes') ;?>"/></div>
	</form>

	<style>
	[name="generaloptions"] th {
		padding-bottom: 0px !important;
	}
	[name="generaloptions"] td {
		padding-bottom: 0px;
		line-height: 15px !important;
	}
	.form-table td {
		padding-top: 0px;
	}
	</style>

	<script>
	// auto rendering pageOptions for POST request
	var postNames = [];
	jQuery('form[name="generaloptions"] input[name!=""], form[name="generaloptions"] select[name!=""], form[name="generaloptions"] textarea[name!=""]').each(function() {
		postNames.push(this.name);
	}).closest('form').append('<input type="hidden" name="_pageOptions" value="' + postNames + '" />');
	</script>
	
</div>