<?php

class espAdminPanel {

	public function __construct(){
		add_action('admin_menu', array(&$this,'add_admin_page'));
		add_action('add_meta_boxes', array(&$this, 'add_meta_box'));
		add_action('save_post', array(&$this, 'save_meta_box_data'));		

		add_filter('tiny_mce_before_init', array(&$this, 'tinymce_settings'), 1);

		function my_admin_theme_style() {
			wp_enqueue_style('my-admin-theme', plugins_url('checkbox_styles.css', __FILE__));
		}
		add_action('admin_enqueue_scripts', 'my_admin_theme_style');
		
		add_action('user_register', function($user_id) {
			$user = wp_get_current_user();
			if (!in_array('subscriber', (array) $user->roles)) {
				$_SESSION['esp_user_created_warning'] = true;
			}
		});
		
		if (isset($_SESSION['esp_user_created_warning'])) {
			unset($_SESSION['esp_user_created_warning']);
			add_action('admin_notices', array(&$this, 'esp_user_created_warning'));
		}
	}
	
	public function esp_user_created_warning() {
    ?>
    <div class="notice notice-warning is-dismissible">
        <p><?php echo 'LET OP: je hebt een nieuwe gebruiker aangemaakt. Als deze gebruiker onder zijn of haar account artikelen gaat publiceren MOET je deze auteur aanvinken bij de Easy Post Promotions om promoties zichtbaar te maken.'; ?></p>
    </div>
    <?php
	}

	public function tinymce_settings($settings) {
		if (!isset($this->baseTinyMCESettingsCSS)) $this->baseTinyMCESettingsCSS = $settings['content_css'];
		$settings['content_css'] = $this->baseTinyMCESettingsCSS;
		return $settings;
	}

	public function add_admin_page(){
		add_options_page('Sharketing Easy Post Promotions', 'Sharketing Easy Post Promotions', 8, dirname (__FILE__) . '/options.php');
	}

	public function add_meta_box() {
		$screens = array('post', 'page');
		foreach ($screens as $screen) {
			add_meta_box(
				'esp_sectionid',
				__( 'Magnate Easy Post Promotion', 'esp_textdomain' ),
				array(&$this, 'print_meta_box'),
				$screen
			);
		}
	}

	public function print_meta_box($post) {
		// Add an nonce field so we can check for it later.
		wp_nonce_field('esp_meta_box', 'esp_meta_box_nonce');

		$value = get_post_meta($post->ID, 'mepp_hide_promotions', true);

		echo '<label for="mepp_hide_promotions" class="selectit"><input name="mepp_hide_promotions" id="mepp_hide_promotions" value="1" ' . checked(!$value, true, false) . ' type="checkbox"> ';
		_e('Show promotions', 'myplugin_textdomain');
		echo '</label> ';

		$disabledLocations = get_post_meta($post->ID, 'esp_disabled_locations', true) ?: array();

		$locations = array('at_the_end' => 'At the end', 'above_the_title' => 'Above the title', 'above_heading' => 'Just above a header', 'banner_left_from_the_content' => 'Banner left from the content', 'above_footer' => 'Above footer', 'after_n_comments' => 'After 1,2,n comments');

		echo '<br><br>Disable promotions for the following location(s) in this post:';

		foreach ($locations as $i => $location) {
			echo '<br><input type="checkbox" id="esp_disable_location'.$i.'" name="esp_disabled_locations[]" value="'.$i.'" ',checked(in_array($i, $disabledLocations)),' />';
			echo '<span class="checkbox-text"><label for="esp_disable_location'.$i.'">';
			_e( $location, 'esp_textdomain' );
			echo '</label></span>';
		}

	}

	public function save_meta_box_data($post_id) {
		/*
		 * We need to verify this came from our screen and with proper authorization,
		 * because the save_post action can be triggered at other times.
		 */

		// Check if our nonce is set.
		if ( ! isset( $_POST['esp_meta_box_nonce'] ) ) {
			return;
		}

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $_POST['esp_meta_box_nonce'], 'esp_meta_box' ) ) {
			return;
		}

		// If this is an autosave, our form has not been submitted, so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return;
			}
		} else {
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
		}

		// Update the meta field in the database.
		update_post_meta($post_id, 'esp_disabled_locations', $_POST['esp_disabled_locations']);
		update_post_meta( $post_id, 'mepp_hide_promotions', !isset($_POST['mepp_hide_promotions']));
	}

	public function save_options(array $options, array $optionNames = null) {
		global $mealLoader;
		if (!is_array($optionNames)) $optionNames = array_keys($options);
		foreach ($optionNames as $option) {
			$option = trim($option);
			if (substr($option, 0, 1) == '_') continue;
			$value = trim($options[$option]);
			$mealLoader->options[$option] = $value;
		}
		$mealLoader->save_options();
	}

	public function save_signature($id, $postData) {
		global $espLoader;
		$signature = $espLoader->save_signature($id, $postData);

		$emptyPromotions = 0;
		if (count($signature['promotions']) > 1) {
			foreach ($signature['promotions'] as $promotion) {
				$content = $promotion['use_custom_html_css_code'] ? $promotion['custom_html_css'] : $promotion['content'];
				if (strlen($content) == 0) $emptyPromotions++;
			}
		}

		if ($duplicate) {
			$err = 'You already made a promotion with exact the same criteria. Please change at least one criteria in order to enable it (despite that fact the promotion is still saved). ';
		}

		if (!isset($_POST['deletepromotion']) && (($emptyPromotions > 0 && !isset($_POST['addpromotion'])) || ($emptyPromotions > 1 && isset($_POST['addpromotion'])))) {
			$err = 'One or more sub promotions are empty. Are you sure about this?';
		}

		return array($signature, $err);
	}

}