<?php

class SelectCategory extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Category';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You didn’t select a category yet. Choose preferably 1 and maximum [max_cats].',
			'nl_NL' => 'LET OP! Je hebt nog geen categorie geselecteerd. Kies er het liefst 1 en maximaal [max_cats].'
		);
		$this->sort = 5.9;
		$this->errorVars = array(
			'max_cats' => intOptionOr('max_categories_post', 2)
		);
	}

	public function isValid($post) {
		// when saving a post we check if nog category is selected, if so we uncategorize post
		// this action will override the default settings for choosing a default category
		if (isset($_POST['post_category'])) {
			if (count($_POST['post_category']) == 1 && $_POST['post_category'][0] == 0) {
				// uncategorize post
				$_POST['post_category'] = array(-1);
			}
		}

		$numCategories = count(wp_get_post_categories($post->ID));
		if ($numCategories == 0) {
			return false;
		}
		return true;
	}
}