<?php

class TooBigParagraphs extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'You have too big blocks/paragraphs of text without enters';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You used one or more too big blocks/paragraphs of text. Add more enters / blank lines.',
			'nl_NL' => 'LET OP! Je hebt één of meer te grote tekstblokken/alinea’s gemaakt! Voeg meer enters/witregels toe.'
		);
		$this->sort = 11.5;
	}

	public function isValid($post) {
		$pattern = '/<p>(.*?)<\/p>/';
		preg_match_all($pattern, str_replace("\n", '', wpautop(get_the_post_content($post))), $matches, PREG_SET_ORDER);
		$tooBigParagraphs = array();
		foreach ($matches as $match) {
			$numWords = str_word_count($match[1]);
			if ($numWords >= intOptionOr('maxParagraphWords', 100)) {
				$tooBigParagraphs []= $match;
			}
		}
		return count($tooBigParagraphs) == 0;
	}
}