<?php

class TooFewBoldWords extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too few bold words';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You have to few bold words, sentences or phrases! There should be a minimum of [min_words].',
			'nl_NL' => 'LET OP! Je hebt te weinig dikgedrukte woorden, zinsdelen of zinnen! Dit moeten er minimaal [min_words] zijn.'
		);
		$this->sort = 16;
		$this->errorVars = array(
			'min_words' => intOptionOr('minBoldWords', 5)
		);
	}

	public function isValid($post) {
		$content = get_the_post_content($post);
		return !$content || $this->getNumBoldWords($content) >= intOptionOr('minBoldWords', 5);
	}

	public function getNumBoldWords($content) {

		$dom = new DOMDocument();
		$dom->loadHTML($content);
		//$b = $dom->getElementsByTagName('b');
		$strong = $dom->getElementsByTagName('strong');

		$getNodeInnerHTML = function(DOMNode $element) {
			$innerHTML = ""; 
			$children  = $element->childNodes;
			foreach ($children as $child) { 
				$innerHTML .= $element->ownerDocument->saveHTML($child);
			}
			return $innerHTML; 
		};

		$numBoldWords = function($els) use ($getNodeInnerHTML) {
			$count = 0;
			foreach ($els as $el) {
				$count += str_word_count($getNodeInnerHTML($el));
			}
			return $count;
		};

		return $numBoldWords($strong); // + $numBoldWords($b)
	}
}