<?php

class TooFewTextBeforeMoreTag extends AFeedbackCheck {
	public function __construct() {
		$this->name = "Too few text before 'more tag'";
		$this->defaultError = array(
			'en_EN' => "ATTENTION! You used too few words before the `more tag` appears. Please put the ‘more tag’ later (min is [min_words] words)",
			'nl_NL' => "LET OP! Je hebt te weinig woorden gebruikt voordat de `more tag` verschijnt. Plaats de ‘more tag’ later (de min is [min_words] woorden)."
		);
		$this->sort = 6.6;
		$this->errorVars = array(
			'min_words' => intOptionOr('minWordsBeforeMoreTag', 50),
		);
	}

	public function isValid($post) {
		$post_content = get_the_post_content($post);
		$morepos = strpos($post_content, '<!--more-->');
		if ($morepos !== false) {
			$wordsBefore = count(explode(' ', substr($post_content, 0, $morepos)));
		}
		return $morepos === false || $wordsBefore >= intOptionOr('minWordsBeforeMoreTag', 50);
	}
}