<?php

class TooMuchCategory extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too Much Category';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You selected too much categories. Choose preferably 1 and maximum [max_cats].',
			'nl_NL' => 'LET OP! Je hebt te veel categorieën geselecteerd. Kies er het liefst 1 en maximaal [max_cats].'
		);
		$this->sort = 5.91;
		$this->errorVars = array(
			'max_cats' => intOptionOr('max_categories_post', 2)
		);
	}

	public function isValid($post) {
		$numCategories = count(wp_get_post_categories($post->ID));
		if ($numCategories > intOptionOr('max_categories_post', 2)) {
			return false;
		}
		return true;
	}
}