<?php
/*
Plugin Name: Sharketing Smart Blogger Feedback
Plugin URI: http://sharketing.nl/
Description: Give your bloggers feedback when they save a concept and publish or schedule an article, like minimum and maximum length of SEO titles, meta-descriptions, headings, words and much more.
Author: sharketing
Version: 1.6.29
Author URI: http://sharketing.nl/?wp
*/
require_once(__DIR__ . '/nofollow/nofollow.php');

if(!defined("idbal16")) {
    define("idbal16", "idbal16");
}

if (!class_exists('msbfLoader')) {
	
	function ssmbf_get_user_role($userid = null) {
		$user = wp_get_current_user();
		return $user->roles;
	}

	function get_saved_post_content() {
		return wp_unslash(!empty($_REQUEST['content']) ? $_REQUEST['content'] : $post_data['content']);
	}

	function get_the_post() {
		return get_post(get_the_ID() ?: $_GET['post']);
	}

	function get_the_post_content($post) {
		$content = $post->post_content;
		// de apply filters zorgt ervoor dat de content nog aangepast kan worden
		// er waren bijvoorbeeld problemen met social media iframes, die werden toegevoegd aan de content
		// dus alleen de ruwe content ophalen, niet apply filters doen
		//$content = apply_filters('the_content', $content);
		$content = str_replace(']]>', ']]&gt;', $content);
		return $content;
	}

	// + added support for plugin wordpressyoast-seo
	function get_the_post_meta_description($post) {
		return get_post_meta($post->ID, 'description', true) ?: get_post_meta($post->ID, '_yoast_wpseo_metadesc', true);

		// all in onse seo pack
		// get_post_meta(get_the_post()->ID, '_aioseop_description', true)
	}
	function get_the_post_seo_title($post) {
		return get_post_meta($post->ID, '_yoast_wpseo_title', true) ?: get_post_meta($post->ID, '_aioseop_title', true) ?: $post->post_title;
	}
	function get_the_post_seo_keywords() {
		return get_post_meta($post->ID, '_yoast_wpseo_focuskw', true) ?: get_post_meta($post->ID, '_aioseop_focuskw', true);
	}

	function has_moretag($post) {
		return strpos(get_the_post_content($post), '<!--more-->');
	}

	function getOption($option) {
		global $msbfLoader;
		return isset($msbfLoader->options[$option]) ? $msbfLoader->options[$option] : null ;
	}

	function setOption($option, $val) {
		global $msbfLoader;
		$msbfLoader->options[$option] = $val;
		$msbfLoader->save_options();
	}

	function intOptionOr($option, $or) {
		return intval(getOption($option)) ?: $or;
	}

	function optionOr($option, $or) {
		return getOption($option) ?: $or;
	}

	function timestamp() {
		return current_time( 'timestamp' );
	}
	
	function langtoiso($lang) {
		$isos = array('English' => 'en_EN', 'Nederlands' => 'nl_NL');
		return $isos[$lang];
	}

	function is_truly_admin() {
		return current_user_can('manage_options');
	}

	function is_post_feedback_ignored($postId) {
		$ignored = getOption('ignoredFeedbackPosts') ?: array();
		return in_array($postId, $ignored);
	}

	class msbfLoader{
		
		var $version     = '';
		var $options     = '';
		var $links = array();
	
		function __construct(){
			$this->load_options();					
			$this->define_constants();
			register_activation_hook( plugin_basename( dirname(__FILE__)).'/msbf.php', array(&$this, 'activate') );
			register_deactivation_hook( plugin_basename( dirname(__FILE__)).'/msbf.php', array(&$this, 'deactivate') );
			wp_register_sidebar_widget(idbal16,'Sharketing Smart Blogger Feedback', array(&$this, 'widget'));
		}

		function save_options() {
			$this->update_options($this->options);
		}
		
		function update_options(array $options) {
			update_option('msbf_options', $options);
		}

		function load_options(){
			// Load the options
			$this->options = get_option('msbf_options');
			/*print_r ($this->options); */
		}
		
		function define_constants() {
			// define URL
			define('MSBF_FOLDER', plugin_basename( dirname(__FILE__)) );
			define('MSBF_URLPATH', WP_PLUGIN_URL . '/' . plugin_basename( dirname(__FILE__) ) . '/' );
		}
		
		function run(){			
			if (is_admin()) {	
				require_once (dirname (__FILE__) . '/admin/admin.php');
				$this->msbfAdminPanel = new msbfAdminPanel();	
			}
				
			require_once (dirname (__FILE__) . '/FormatHandler.php');
			$this->formatHandler = new FormatHandler();	

			require_once (dirname (__FILE__) . '/FeedbackHandler.php');
			$this->feedbackHandler = new FeedbackHandler();	
			
			require_once(dirname (__FILE__) . '/comments-hooks.php');
			

			if (is_admin()) {
				function remove_my_post_metaboxes() {
					if (!current_user_can('manage_options')) {
						if (getOption('hideTagsAuthors')) {
							remove_meta_box('tagsdiv-post_tag', 'post', 'normal');
							remove_meta_box('tagsdiv-post_tag', 'page', 'normal');
						}
					}
				}
				add_action('admin_menu','remove_my_post_metaboxes');

				$this->formatHandler->init();
			}
			

			require_once (dirname (__FILE__) . '/NotificationsHandler.php');
			$this->notificationsHandler = new NotificationsHandler();	
			
			if (!is_admin()) {
				$this->feedbackHandler->handleNonFeedbackOptions();
				$this->formatHandler->handleNonAdminFormatOptions();
			} else {			
				if (!getOption('initCheckedPosts')) {
					$this->feedbackHandler->checkAllPosts();
					setOption('initCheckedPosts', 1);
				}
			}


			// opdracht 22.68
			// non-admins mogen niet de views zien van posts (in wp-admin/edit.php)
			if (!is_truly_admin()) {
				remove_action('manage_posts_custom_column', 'add_postviews_column_content');
				remove_action('manage_posts_columns', 'add_postviews_column');
			}
			
			global $WishListMemberInstance;
			if (isset($WishListMemberInstance)) {
				add_action('senhblog_init', function() {
					global $WishListMemberInstance;
					$categories = get_the_category();
					if (!is_array($categories)) {
						$categories = array($categories);
					}
					foreach ($categories as $category) {
						// $WishListMemberInstance->CatProtected($category->term_id, 'N');
						$WishListMemberInstance->cat_protected($category->term_id, 'N');
					}
				});
				
				if (is_admin()) {
					add_action('admin_footer', function() {
						?>
						<script>jQuery('[name="wlmember_protect_category"]').parent().parent().html('<i>Sharketing Smart Feedback Blogger has disabled category protection.</i>');</script>
						<?php
					});
				}
			}
		}
		
		function activate(){
			$options = $this->options;
			if (empty($options)){
				$options = array();
				$options['activatePlugin'] = true;
				$options['feedbackLanguage'] = $options['formatOptionsLanguage'] = 'English';
				$this->update_options($options);
			}
		}

		function deactivate() {
			setOption('initCheckedPosts', 0);
		}
		
		/**
		* Show a error messages
		*/
		function show_error($message) {
			echo '<div class="wrap"><h2></h2><div class="error" id="error"><p>' . $message . '</p></div></div>' . "\n";
		}
		
		/**
		* Show a system messages
		*/
		function show_message($message) {
			echo '<div class="wrap"><h2></h2><div class="updated fade" id="message"><p>' . $message . '</p></div></div>' . "\n";
		}
		
		/**
		 * widget
		 *
		 * The sidebar widget 
		 */
		function widget($args){
			extract($args);
			//Manditory before widget junk
			echo $before_widget;
			/*echo '<li>'; */
			global $mwm_aal; $mwm_aal->output_sidebar_links();
			/*echo '</li>'; */
			//Manditory after widget junk
			echo $after_widget;
		}
		
		
	
	}
	//Start Loader
	global $msbfLoader;
	$msbfLoader = new msbfLoader();
	add_action('plugins_loaded', array(&$msbfLoader, 'run'));
}


