<?php

/**
 * Register folder protection hooks
 *
 * @package WishListMember/Features/Folder_Protection
 */

namespace WishListMember\Features\Folder_Protection;

// Register methods.
add_filter(
    'wishlistmember_instance_methods',
    /**
     * Callback for `wishlistmember_instance_methods` filter.
     *
     * Registers folder protection methods.
     *
     * @param array $methods The methods array.
     *
     * @return array
     */
    function ($methods) {
        $object         = new Folder_Protection_Methods();
        $object_methods = get_class_methods($object);
        foreach ($object_methods as $method) {
            $methods[ $method ] = [[$object, $method]];
        }
        return $methods;
    }
);
