<?php

/**
 * Main file that loads the Mothership Connection and its Services.
 *
 * @package WishListMember\Features\Mothership
 */

declare(strict_types=1);

namespace WishListMember\Features\Mothership;

use WishListMember\GroundLevel\Container\Container;
use WishListMember\GroundLevel\Mothership\Service as MoshService;

require_once 'ipn-notification-handler.php';

$container = new Container();

// Instantiate the Mothership Service.
$container->addService(
    MoshService::class,
    static function () use ($container): MoshService {
        return new MoshService(
            $container,
            new Mothership_Plugin_Connector()
        );
    },
    true
);

// Load the IPN Notification Handler.
(new IPN_Notification_Handler())->load_hooks($container);
