<?php

/**
 * WishList Member for Infusionsoft plugin update fixer for version 1.1.0 and lower.
 *
 * @todo Remove this feature by January 2025.
 *
 * @package    WishListMember
 * @subpackage WLMIS
 */

namespace WishListMember\WLMISUpdateFix;

add_action(
    'plugins_loaded',
    /**
     * Remove WLMIS site_transient_update_plugins filter
     * if version is 1.1.0 or lower and replace it with ours.
     */
    function () {
        static $done = false;
        global $wishlist_ifconnect;

        // Run only once.
        if ($done) {
            return;
        }
        $done = true;

        // Check that $wishlist_ifconnect is an object of the WishList_forInfusionsoft class.
        if (!is_a((object)$wishlist_ifconnect, '\WishList_forInfusionsoft')) {
            return;
        }

        // Get WLMIS version.
        $wlmis_file = (array) get_option('active_plugins', []);
        $wlmis_file = preg_grep('/\/wishlist\-ifconnect\.php$/i', $wlmis_file);
        if (!$wlmis_file) {
            return;
        }
        list($wlmis_file) = $wlmis_file;
        $version = get_file_data(trailingslashit(WP_PLUGIN_DIR) . $wlmis_file, ['version' => 'version'])['version'];

        // Run only if WLMIS version is 1.1.0 or lower.
        if (version_compare($version, '1.1.0', '>')) {
            return;
        }

        // Delete WLMIS latest version transient if it's below 1.1.1
        $version_transient_name = 'wishlist-ifconnect_latest_plugin_version';
        if (version_compare((string)get_transient($version_transient_name), '1.1.1', '<')) {
            delete_transient($version_transient_name);
        }


        // Replace WLMIS site_transient_update_plugins filter with ours.
        remove_filter('site_transient_update_plugins', [$wishlist_ifconnect, 'plugin_update_notice']);
        add_filter('site_transient_update_plugins', __NAMESPACE__ . '\wlmis_update_fixer');
    }
);

/**
 * Our site_transient_update_plugins filter.
 *
 * @param  object $transient Plugins update transient data.
 * @return object
 */
function wlmis_update_fixer($transient)
{
    global $wishlist_ifconnect;
    // Return WLMIS `plugin_update__notice()` value if `$transient` is an object, otherwise return original.
    return is_object($transient) ? $wishlist_ifconnect->plugin_update_notice($transient) : $transient;
}
