<?php

$data = $ar_data[ $config['id'] ] ?? [];
$keap_authorization_url = '';
if (class_exists('\WishListMember\Infusionsoft\WLM_Infusionsoft')) {
    $ifsdk = new \WishListMember\Infusionsoft\WLM_Infusionsoft('autoresponder');
    $keap_authorization_url = $ifsdk->get_oauth_authorize_url();
}

$keap_action = wlm_post_data()['action'];
if ('wlm_autoresponder_disconnect_keap' === $keap_action) {
    $app_name = wlm_post_data()['app'];
    $nonce = wlm_post_data()['wlm_autoresponder_disconnect_keap_' . $app_name];
    if (wp_verify_nonce($nonce, 'wlm_autoresponder_disconnect_keap_' . $app_name)) {
        $autoresponder_app = wishlistmember_instance()->get_option('keap_oauth_app_autoresponder');
        $oauth_token = wishlistmember_instance()->get_option('keap_oauth_token_autoresponder');
        $transient_name = $oauth_token ? $oauth_token->accessToken : '';
        if ($transient_name) {
            delete_transient('wlmisar_' . md5($transient_name));
        }
        delete_transient('keap_token_refresh_autoresponder');
        wishlistmember_instance()->delete_option('keap_oauth_app_autoresponder');
        wishlistmember_instance()->delete_option('keap_oauth_token_autoresponder');
        wishlistmember_instance()->delete_option('keap_oauth_code_autoresponder');
    }
}

$autoresponder_app = wishlistmember_instance()->get_option('keap_oauth_app_autoresponder');
$oauth_token = wishlistmember_instance()->get_option('keap_oauth_token_autoresponder');

$isapikey = $data['iskey'] ?? false;

$show_deprecation_msg = $isapikey ? true : false;
$show_deprecation_msg = $oauth_token ? false : $show_deprecation_msg;

thirdparty_integration_data($config['id'], $data);
