<?php if ($show_deprecation_msg) : ?>
<div class="row">
    <div class="col">
        <p class="text-danger alert alert-danger">
            <?php esc_html_e('Infusionsoft by Keap is sunsetting their Legacy API keys. You will need to use the button below to reconnect your Infusionsoft by Keap integration. The integration must be reconnected for it to continue to function.', 'wishlist-member'); ?>
        </p>
    </div>
</div>
<?php endif; ?>
<div class="row mb-4">
    <div class="col-auto mb-0">
        <?php if ($keap_authorization_url) : ?>
        <a class="btn -primary" href='<?php echo esc_url($keap_authorization_url); ?>'>
            <i class="wlm-icons">developer_board</i>
            <span>
                <?php
                switch(true) {
                    case $show_deprecation_msg:
                        esc_html_e('Reconnect Infusionsoft by Keap Integration', 'wishlist-member');
                        break;
                    case $oauth_token:
                        esc_html_e('Reconnect to Infusionsoft by Keap', 'wishlist-member');
                        break;
                    default:
                        esc_html_e('Connect to Infusionsoft by Keap', 'wishlist-member');
                }
                ?>
            </span>
        </a>
        <?php endif; ?>
    </div>
    <?php echo wp_kses_post($api_status_markup); ?>
    <?php if ($oauth_token) : ?>
        <?php
            $app_name = explode('.', $autoresponder_app)[0];
        ?>
        <div class="col-2 text-right">
            <form method="post" onsubmit="return confirm (wp.i18n.__('Disconnecting the Infusionsoft by Keap Account will prevent this WishList Member email integration from working.'))">
                <?php wp_nonce_field('wlm_autoresponder_disconnect_keap_' . $app_name, 'wlm_autoresponder_disconnect_keap_' . $app_name); ?>
                <input type="hidden" name="action" value="wlm_autoresponder_disconnect_keap">
                <input type="hidden" name="app" value="<?php echo esc_attr($app_name); ?>">
                <button type="submit" class="btn -condensed -danger" href='#'>
                    <i class="wlm-icons">info_outline</i>
                    <span><?php esc_html_e('Disconnect', 'wishlist-member'); ?></span>
                </button>
            </form>
        </div>
    <?php endif; ?>
</div>
