<?php

// Payment Integration : Infusionsoft.
require_once 'admin/init.php';

$all_tabs = [
    'settings' => 'Settings',
    'products' => 'Products',
    'cron' => 'Cron Job',
    'tutorial' => 'Tutorial',

];
$active_tab = 'settings';
$api_not_required = ['settings', 'tutorial'];

$ar = wishlistmember_instance()->get_option('Autoresponders');
$keap_email_provider_settings = isset($ar['infusionsoft']) ? $ar['infusionsoft'] : [];
$email_iskey = $keap_email_provider_settings['iskey'] ?? '';
// Check if Keap Email Provider integration is enabled and is using the same App Name and Encrypted Key.
if (wishlistmember_instance()->email_integration_is_active('infusionsoft')) {
    $payment_app = wishlistmember_instance()->get_option('keap_oauth_app_payment');
    $autoresponder_app = wishlistmember_instance()->get_option('keap_oauth_app_autoresponder');
    $same_keap_account = false;
    if ($email_iskey && $email_iskey === wishlistmember_instance()->get_option('isapikey')) {
        $same_keap_account = true;
    }
    $same_keap_account = $payment_app ? $payment_app === $autoresponder_app : $same_keap_account;
    if ($same_keap_account) {
        printf('<p><b> %s </b> %s</p>', 'Please Note:', __('The Keap Email integration with WishList Member is also enabled in the Setup > Integrations > Email Providers section and is using the same connection as the Keap Payment Integration. This means the Keap account tags will be available in both of the Keap integration sections in WishList Member.', 'wishlist-member'));
    }
}

echo '<ul class="nav nav-tabs">';
foreach ($all_tabs as $k => $v) {
    $active = $active_tab === $k ? 'active' : '';
    $api_required = in_array($k, $api_not_required, true) ? '' : 'api-required';
    printf('<li class="%s %s nav-item"><a class="nav-link" data-toggle="tab" href="#%s_%s">%s</a></li>', esc_attr($active), esc_attr($api_required), esc_attr($config['id']), esc_attr($k), esc_attr($v));
}
echo '</ul>';
echo '<div class="tab-content">';
foreach ($all_tabs as $k => $v) {
    $active = $active_tab === $k ? 'active in' : '';
    $api_required = in_array($k, $api_not_required, true) ? '' : 'api-required';
    printf('<div id="%s_%s" class="tab-pane %s %s">', esc_attr($config['id']), esc_attr($k), esc_attr($api_required), esc_attr($active));
    include_once 'admin/tabs/' . $k . '.php';
    echo '</div>';
}
echo '</div>';

wlm_print_script(plugin_dir_url(__FILE__) . 'assets/admin.js');
wlm_print_style(plugin_dir_url(__FILE__) . 'assets/admin.css');
