<?php
/**
 * @license MIT
 *
 * Modified by caseproof on 06-January-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */ namespace Infusionsoft\Api\Rest;

use WishListMember\Infusionsoft\Api\Rest\Traits\CannotCreate;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotDelete;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotFind;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotList;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotSave;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotSync;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotWhere;

class WishListMember_UserInfoService extends WishListMember_RestModel
{
    use CannotList, CannotWhere, CannotSync, CannotSave, CannotFind, CannotDelete, CannotCreate;

    public $full_url = 'https://api.infusionsoft.com/crm/rest/v1/oauth/connect/userinfo';

    public function get()
    {

        $data = $this->client->restfulRequest('get', $this->getIndexUrl());

        return $data;
    }

}