<?php
/**
 * @license MIT
 *
 * Modified by caseproof on 06-January-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace WishListMember\Infusionsoft\Http;

interface ClientInterface {

	/**
	 * @return \WishListMember\fXmlRpc\Transport\TransportInterface
	 */
	public function getXmlRpcTransport();

	/**
	 * Sends a request to the given URI and returns the raw response.
	 *
	 * @param $method
	 * @param string $uri
	 * @param array $options
	 * @return mixed
	 * @internal param array $params
	 * @internal param array $headers
	 * @internal param string $method
	 */
	public function call($method, $uri, array $options);

}
