<?php

$incremental_index = time();
$fields            = [
    'nonce'              => [
        'type'  => 'hidden',
        'name'  => 'nonce',
        'label' => '',
        'value' => wp_create_nonce('stripe-do-charge'),
        'class' => '',
    ],
    'stripe_action'      => [
        'type'  => 'hidden',
        'name'  => 'stripe_action',
        'label' => '',
        'value' => 'charge',
        'class' => '',
    ],
    'charge_type'        => [
        'type'  => 'hidden',
        'name'  => 'charge_type',
        'label' => '',
        'value' => 'existing',
        'class' => '',
    ],
    'subscription'       => [
        'type'  => 'hidden',
        'name'  => 'subscription',
        'label' => '',
        'value' => $settings['subscription'],
        'class' => '',
    ],
    'product'            => [
        'type'  => 'hidden',
        'name'  => 'product',
        'label' => '',
        'value' => wlm_arrval($data, 'sc_details', 'plan_details', 0, 'product'),
        'class' => '',
    ],
    'redirect_to'        => [
        'type'  => 'hidden',
        'name'  => 'redirect_to',
        'label' => '',
        'value' => get_permalink(),
        'class' => '',
    ],
    'sku'                => [
        'type'  => 'hidden',
        'name'  => 'sku',
        'label' => '',
        'value' => $sku,
        'class' => '',
    ],
    // Name fields.
    $incremental_index++ => [
        'type'  => 'heading',
        'text'  => __('Personal Information', 'wishlist-member'),
        'class' => 'section-personal',
    ],
    'first_name'         => [
        'type'        => 'text',
        'name'        => 'first_name',
        'label'       => __('First Name', 'wishlist-member'),
        'placeholder' => __('First Name', 'wishlist-member'),
        'value'       => $current_user->first_name,
        'col'         => 'col-6 section-personal',
    ],
    'last_name'          => [
        'type'        => 'text',
        'name'        => 'last_name',
        'label'       => __('Last Name', 'wishlist-member'),
        'placeholder' => __('Last Name', 'wishlist-member'),
        'value'       => $current_user->last_name,
        'col'         => 'col-6 section-personal',
    ],
    'email'              => [
        'type'        => 'text',
        'name'        => 'email',
        'label'       => __('Email', 'wishlist-member'),
        'placeholder' => __('Email', 'wishlist-member'),
        'value'       => $current_user->user_email,
        'col'         => 'col-12 section-personal',
    ],
    $incremental_index++ => [
        'type'  => 'heading',
        'text'  => __('Billing Information', 'wishlist-member'),
        'class' => 'section-payment',
    ],
    'coupon'             => [
        'type'          => $coupon ? 'text' : 'none',
        'name'          => 'coupon',
        'label'         => __('Coupon Code', 'wishlist-member'),
        'placeholder'   => __('Coupon Code', 'wishlist-member'),
        'class'         => 'stripe-coupon',
        'value'         => wlm_or(wlm_trim(wlm_get_data()['coupon']), ''),
        'error_text'    => __('Invalid Coupon Code', 'wishlist-member'),
        'success_text'  => __('Coupon Code Applied', 'wishlist-member'),
        'checking_text' => __('Checking Coupon Code', 'wishlist-member'),
        'col'           => 'col-12 section-coupon',
    ],
    $incremental_index++ => [
        'type'  => 'heading',
        'style' => 'display: none; ',
        'class' => ' section-prorate prorate prorate-' . $sku,
        'text'  => __('Prorate Plan', 'wishlist-member'),
    ],
    'proration'          => [
        'type'             => 'proration',
        'prorate'          => $settings['allow_proration_for_level'] ?? false,
        'upgrade_to_level' => '', // selected level for registration (upgrade to)
        'level_id'         => '', // prorated level (upgrade from)
        'txn_id'           => '', // prorated level txnID
        'existing_levels'  => isset($prorate_levels) ? $prorate_levels : [],
        'col'              => 'col-12 section-prorate',
    ],
    $incremental_index++ => [
        'type'  => 'heading',
        'text'  => __('Card Details', 'wishlist-member'),
        'class' => 'section-payment',
    ],
    // Card fields.
    'cc_fields'          => [
        'type' => 'cc_fields',
        'has'  => ['cc_cvc'],
        'col'  => 'col-12 section-payment',
    ],

];

// If amount or currency was overriden, lets put a hash.
// This will insure that amount is not rigged.
if ($btn_hash) {
    $fields['btn_hash']        = [
        'type'  => 'hidden',
        'name'  => 'btn_hash',
        'label' => '',
        'value' => wp_create_nonce($btn_hash),
        'class' => '',
    ];
    $fields['custom_amount']   = [
        'type'  => 'hidden',
        'name'  => 'custom_amount',
        'label' => '',
        'value' => $amt,
        'class' => '',
    ];
    $fields['custom_currency'] = [
        'type'  => 'hidden',
        'name'  => 'custom_currency',
        'label' => '',
        'value' => $currency,
        'class' => '',
    ];
}

$data['fields']               = $fields;
$data['heading']              = $heading;
$data['hide_button_currency'] = (int) $hide_button_currency;

$data['panel_button_label'] = $panel_btn_label;
if (0 == $hide_button_currency) {
    $data['panel_button_label'] .= ' ' . $currency . ' ' . $amt;
}

$data['button_label'] = $panel_btn_label;

if (0 == $hide_button_currency) {
    $data['button_label'] .= ' ' . $currency . ' ';
}

$data['form_action'] = $stripethankyou_url;
$data['id']          = $sku;
$data['logo']        = $logo;
$data['showlogin']   = (bool) $showlogin;
