<?php
/**
 * Cleanup WP
 */
function wpo_remove_plugin_css() {
	wp_dequeue_style( 'wp-block-library' );
	wp_dequeue_style( 'wp-block-library-theme' );
	wp_dequeue_style( 'wc-block-style' ); // Remove WooCommerce block CSS
	wp_dequeue_style( 'storefront-gutenberg-blocks' ); // Storefront theme
	wp_dequeue_style( 'gform_chosen' );
	wp_dequeue_style( 'site-reviews' );
	wp_dequeue_style( 'search-filter-plugin-styles' );
}
add_action('wp_enqueue_scripts', 'wpo_remove_plugin_css', 999);

// remove header links
function wpo_head_cleanup() {
	remove_action( 'wp_head', 'feed_links_extra', 3 );                      // Category Feeds
	remove_action( 'wp_head', 'feed_links', 2 );                            // Post and Comment Feeds
	remove_action( 'wp_head', 'rsd_link' );                                 // EditURI link
	remove_action( 'wp_head', 'wlwmanifest_link' );                         // Windows Live Writer
	remove_action( 'wp_head', 'index_rel_link' );                           // index link
	remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 );              // previous link
	remove_action( 'wp_head', 'start_post_rel_link', 10, 0 );               // start link
	remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );   // Links for Adjacent Posts
	remove_action( 'wp_head', 'wp_generator' );                             // WP version
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );			// Emoji
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' ); // Emoji
	remove_action( 'wp_print_styles', 'print_emoji_styles' );				// Emoji
	remove_action( 'admin_print_styles', 'print_emoji_styles' );			// Emoji
	
	if (!is_admin()) {
		wp_deregister_script('jquery');                                     // De-Register jQuery
		wp_deregister_script( 'wp-embed' );                                 // De-Register wp-embed
		wp_deregister_script( 'jquery-ui-datepicker' );                     // De-Register datepicker
		wp_register_script('jquery', '', '', '', true);                     // Register as 'empty', because we manually insert our script in header.php
		
		wp_dequeue_style('admin-bar');
		wp_dequeue_style('customize-preview');
		wp_dequeue_style('customize-nav-menus');
		wp_dequeue_style('customize-widgets');
		wp_dequeue_style('editor-buttons');
		wp_dequeue_style('wp-color-picker');
		wp_dequeue_style('wp-embed-template-ie');
		wp_dequeue_style('wp-auth-check');
		wp_dequeue_style('code-editor');
		wp_dequeue_style('thickbox');
		wp_dequeue_style('wp-mediaelement');
		wp_dequeue_style('media-views');
		wp_dequeue_style('imgareaselect');
		wp_dequeue_style('wp-block-library');
		wp_dequeue_style('wp-block-library-theme');
		wp_dequeue_style('buttons');
	}
}
add_action('init', 'wpo_head_cleanup');

// remove WP version from RSS
add_filter('the_generator', 'wpo_rss_version');
function wpo_rss_version() { return ''; }