<?php
/**
 * Plugin name: WordPress Onderhoud
 * Description: Deze plugin is benodigd voor beveiliging, performance en om informatie te verzamelen
 * Author: WPonderhoud.nl
 * Author URI: https://www.wponderhoud.nl/
 * Version: 1.3.3.7
 * Requires at least: 5
 * Requires PHP: 5.6.0
 * Plugin URI: https://www.wponderhoud.nl/
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * Network: false
 * Text Domain: wponderhoud
 */

/**/

defined( 'ABSPATH' ) || exit;

define( 'WPOPLUGIN_VERSION', '1.3.3.7' );
define( 'WPOPLUGIN__FILE__', __FILE__ );
define( 'WPOPLUGIN_PATH', trailingslashit( plugin_dir_path( WPOPLUGIN__FILE__ ) ) );
define( 'WPOPLUGIN_LIB_PATH', WPOPLUGIN_PATH . 'library/' );
define( 'WPOPLUGIN_ASSETS_PATH', WPOPLUGIN_PATH . 'assets/' );
define( 'WPOPLUGIN_VENDOR_PATH', WPOPLUGIN_PATH . 'vendor/' );
define( 'WPOPLUGIN_OPT_PATH', WPOPLUGIN_PATH . 'optimize/' );
define( 'WPOPLUGIN_LOG_PATH', WP_CONTENT_DIR . '/wpo-logs/' );
define( 'WPOPLUGIN_OUTDATED_FILE', WPOPLUGIN_LOG_PATH . 'outdated.json' );

define( 'WPOPLUGIN_ROLLBACK_PATH', WPOPLUGIN_VENDOR_PATH . 'wp-rollback/' );
define( 'WPOPLUGIN_SKIPUPDATES_PATH', WPOPLUGIN_VENDOR_PATH . 'skip-updates/' );


require_once WPOPLUGIN_LIB_PATH . 'class-manager.php';
require_once WPOPLUGIN_LIB_PATH . 'functions-wpo.php';
require_once WPOPLUGIN_LIB_PATH . 'vendi-abandoned-plugin-check.php';
require_once WPOPLUGIN_LIB_PATH . 'class-phprequire.php';
require_once WPOPLUGIN_LIB_PATH . 'CronjobClient.php';
require_once WPOPLUGIN_ROLLBACK_PATH . 'wp-rollback.php';
require_once WPOPLUGIN_SKIPUPDATES_PATH . 'skip-updates.php';
if (get_option('wpo_cleanups_field') == 1) {
	require_once WPOPLUGIN_OPT_PATH . 'global-cleanup-wp.php';
	require_once WPOPLUGIN_OPT_PATH . 'global-html-minify.php';
}
\UpdateActivity\Manager::init();



if( ! class_exists( 'wpoPluginUpdateChecker' ) ) {
	
	class wpoPluginUpdateChecker{
		
		public $plugin_slug;
		public $version;
		public $cache_key;
		public $cache_allowed;
		
		public function __construct() {
			
			$this->plugin_slug = plugin_basename( __DIR__ );
			$this->version = WPOPLUGIN_VERSION;
			$this->cache_key = 'wpo_plugin_updater';
			$this->cache_allowed = true;
			
			add_filter( 'plugins_api', array( $this, 'info' ), 20, 3 );
			add_filter( 'site_transient_update_plugins', array( $this, 'update' ) );
			add_action( 'upgrader_process_complete', array( $this, 'purge' ), 10, 2 );
			
		}
		
		public function request(){
			
			$remote = get_transient( $this->cache_key );
			
			if( false === $remote || ! $this->cache_allowed ) {
				
				$remote = wp_remote_get(
					'https://www.artitex.nl/wp-content/wpoplugin/info.php',
					array(
						'timeout' => 30,
						'headers' => array(
							'Accept' => 'application/json'
						)
					)
				);
				
				if(
					is_wp_error( $remote )
					|| 200 !== wp_remote_retrieve_response_code( $remote )
					|| empty( wp_remote_retrieve_body( $remote ) )
				) {
					return false;
				}
				
				set_transient( $this->cache_key, $remote, 120 );
				
			}
			
			$remote = json_decode( wp_remote_retrieve_body( $remote ) );
			
			return $remote;
			
		}
		
		
		function info( $res, $action, $args ) {
			
			// print_r( $action );
			// print_r( $args );
			
			// do nothing if you're not getting plugin information right now
			if( 'plugin_information' !== $action ) {
				return $res;
			}
			
			// do nothing if it is not our plugin
			if( $this->plugin_slug !== $args->slug ) {
				return $res;
			}
			
			// get updates
			$remote = $this->request();
			
			if( ! $remote ) {
				return $res;
			}
			
			$res = new stdClass();
			
			$res->name = $remote->name;
			$res->slug = $remote->slug;
			$res->version = $remote->version;
			$res->tested = $remote->tested;
			$res->requires = $remote->requires;
			$res->author = $remote->author;
			$res->author_profile = $remote->author_profile;
			$res->download_link = $remote->download_url;
			$res->trunk = $remote->download_url;
			$res->requires_php = $remote->requires_php;
			$res->last_updated = $remote->last_updated;
			
			$res->sections = array(
				'description' => $remote->sections->description,
				'installation' => $remote->sections->installation,
				'changelog' => $remote->sections->changelog
			);
			
			if( ! empty( $remote->banners ) ) {
				$res->banners = array(
					'low' => $remote->banners->low,
					'high' => $remote->banners->high
				);
			}
			
			return $res;
			
		}
		
		public function update( $transient ) {
			
			if ( empty($transient->checked ) ) {
				return $transient;
			}
			
			$remote = $this->request();
			
			if(
				$remote
				&& version_compare( $this->version, $remote->version, '<' )
				&& version_compare( $remote->requires, get_bloginfo( 'version' ), '<=' )
				&& version_compare( $remote->requires_php, PHP_VERSION, '<' )
			) {
				$res = new stdClass();
				$res->slug = $this->plugin_slug;
				$res->plugin = plugin_basename( __FILE__ );
				$res->new_version = $remote->version;
				$res->tested = $remote->tested;
				$res->package = $remote->download_url;

				$transient->response[ $res->plugin ] = $res;

			}
			
			return $transient;
			
		}
		
		public function purge( $upgrader, $options ){
			
			if (
				$this->cache_allowed
				&& 'update' === $options['action']
				&& 'plugin' === $options[ 'type' ]
			) {
				// just clean the cache when new plugin version is installed
				delete_transient( $this->cache_key );
			}
			
		}
		
	}
	new wpoPluginUpdateChecker();
}


add_filter( 'plugin_row_meta', function( $links_array, $plugin_file_name, $plugin_data, $status ) {
	if( strpos( $plugin_file_name, basename( __FILE__ ) ) ) {
		$links_array[] = sprintf(
			'<a href="%s" class="thickbox open-plugin-details-modal">%s</a>',
			add_query_arg(
				array(
					'tab' 		=> 'plugin-information',
					'plugin' 	=> plugin_basename( __DIR__ ),
					'TB_iframe' => true,
					'width' 	=> 772,
					'height' 	=> 788
				),
				admin_url( 'plugin-install.php' )
			),
			__( 'View details' )
		);
	}
	return $links_array;
}, 25, 4 );