<?php

add_action('customize_register', 'senhblog_header_customize_register');
function senhblog_header_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_header', array(
        'title'    => customize_options_language('4. Header', '4. Hoofd'),
        'description' => '',
        'priority' => 123,
    ));
 
	/*$wp_customize->add_setting('header_fillwidth', array(
		'default'        => false,
		'transport' => 'refresh'
	)); 
	$wp_customize->add_control('header_fillwidth', array(
		'label'      => customize_options_language('Make header fullwidth', 'Maak hoofd (header) volledige breedte'),
		'section'    => 'senhblog_header',
		'settings'   => 'header_fillwidth',
		'type' => 'checkbox'
	));*/

	$wp_customize->add_setting('header_height', array(
        'default'        => 100,
        'transport'     => 'postMessage'
    )); 
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'header_height', array(
        'label'      => customize_options_language('Header height', 'Hoofd (header) hoogte') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_height',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 100
    )));

	$wp_customize->add_setting(
		'header_background',
		array(
			'default' => '#F8EFE4',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'header_background',
			array(
				'label'      => customize_options_language('Header background', 'Hoofd (header) achtergrond') . ':',
				'section'    => 'senhblog_header',
				'settings'   => 'header_background'
			)
		)
	);

	$wp_customize->add_setting(
		'header_background_image',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'header_background_image',
			array(
				'label'      => customize_options_language('Header background image', 'Hoofd (header) achtergrondafbeelding') . ':',
				'section'    => 'senhblog_header',
				'settings'   => 'header_background_image'
			)
		)
	);

	$wp_customize->add_setting('header_background_image_cover', array(
		'default'        => false,
		'transport' => 'refresh'
	)); 
	$wp_customize->add_control('header_background_image_cover', array(
		'label'      => customize_options_language('Allow header background to stretch full width', 'Hoofd (header) achtergrondafbeelding uitrekken in de volledige breedte'),
		'section'    => 'senhblog_header',
		'settings'   => 'header_background_image_cover',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting('header_background_image_atts', array(
        'default'        => 'center center',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('header_background_image_atts', array(
        'label'      => customize_options_language('Add CSS to header background-image', 'Voeg CSS toe aan hoofd (header) achtergrondafbeelding background-image') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_background_image_atts'
    ));	

	$wp_customize->add_setting(
		'header_image',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'header_image',
			array(
				'label'      => customize_options_language('Header image', 'Hoofd (header) afbeelding') . ':',
				'section'    => 'senhblog_header',
				'settings'   => 'header_image'
			)
		)
	);

	$wp_customize->add_setting('header_image_url', array(
        'default'        => '',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('header_image_url', array(
        'label'      => customize_options_language('Header image URL (alternative)', 'Hoofd (header) afbeelding URL (alternatief)') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_image_url'
    ));

	$wp_customize->add_setting('header_image_margin_top', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'header_image_margin_top', array(
        'label'      => customize_options_language('Header image margin top', 'Hoofd (header) afbeelding afstand top') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_image_margin_top',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('header_image_margin_left', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'header_image_margin_left', array(
        'label'      => customize_options_language('Header image margin left', 'Hoofd (header) afbeelding afstand links') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_image_margin_left',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('header_image_margin_bottom', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'header_image_margin_bottom', array(
        'label'      => customize_options_language('Header image margin bottom', 'Hoofd (header) afbeelding afstand onder') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_image_margin_bottom',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('header_allow_scroll', array(
		'default'        => true,
		'transport' => 'refresh'
	)); 
	$wp_customize->add_control('header_allow_scroll', array(
		'label'      => customize_options_language('Allow header to scroll with page', 'Hoofd (header) mee laten scrollen met pagina'),
		'section'    => 'senhblog_header',
		'settings'   => 'header_allow_scroll',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting('header_affix_height', array(
        'default'        => '100',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'header_affix_height', array(
        'label'      => customize_options_language('Header height on scroll', 'Hoofd (header) hoogte bij scroll') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_affix_height',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 100,
		'extra_select_name' => '',
		'extra_select_choices' => array('%' => '%')
    )));

	/*$wp_customize->add_setting('header_extra_menu_position', array(
        'default'        => 'hide',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('header_extra_menu_position', array(
        'label'      => customize_options_language('Extra header menu', 'Extra header menu') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_extra_menu_position',
		'type'		=> 'select',
		'choices' => array('hide' => customize_options_language('Hide menu', 'Niet weergeven'), 'right' => customize_options_language('Align right', 'Rechts weergeven'))
    ));*/

	$wp_customize->add_setting('header_extra_menu_seperator', array(
        'default'        => '',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('header_extra_menu_seperator', array(
        'label'      => customize_options_language('Extra menu seperator', 'Extra menu scheidingstekens') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_extra_menu_seperator'
    ));

	$wp_customize->add_setting(
		'header_extra_menu_fontcolor',
		array(
			'default' => '#FFFFFF',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'header_extra_menu_fontcolor',
			array(
				'label'      => customize_options_language('Extra menu font color', 'Extra menu tekstkleur') . ':',
				'section'    => 'senhblog_header',
				'settings'   => 'header_extra_menu_fontcolor'
			)
		)
	);

	/*$wp_customize->add_setting('header_extra_menu_fontfamily', array(
        'default'        => 'Verdana',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('header_extra_menu_fontfamily', array(
        'label'      => customize_options_language('Extra menu font', 'Extra menu lettertype') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_extra_menu_fontfamily',
		'type'		=> 'select',
		'choices' => array('Arial' => 'Arial', 'OpenSans' => 'Open Sans', 'Roboto' => 'Roboto', 'Verdana' => 'Verdana', 'Helvetica' => 'Helvetica', 'HelveticaNeue' => 'Helvetica Neue', 'Lato' => 'Lato', 'SansSerif' => 'sans-serif')
    ));*/

	$wp_customize->add_setting('header_extra_menu_fontsize', array(
        'default'        => '12',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('header_extra_menu_fontsize', array(
        'label'      => customize_options_language('Extra menu font size', 'Extra menu lettertype grootte') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_extra_menu_fontsize',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('header_extra_menu_uppercase', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('header_extra_menu_uppercase', array(
        'label'      => customize_options_language('Use only uppercase?', 'Alles met hoofdletters?'),
        'section'    => 'senhblog_header',
        'settings'   => 'header_extra_menu_uppercase',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('header_extra_menu_margintop', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'header_extra_menu_margintop', array(
        'label'      => customize_options_language('Extra menu margin top', 'Extra menu afstand top') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_extra_menu_margintop',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 0
    )));

	$wp_customize->add_setting('header_extra_menu_marginright', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'header_extra_menu_marginright', array(
        'label'      => customize_options_language('Extra menu margin right', 'Extra menu afstand right') . ':',
        'section'    => 'senhblog_header',
        'settings'   => 'header_extra_menu_marginright',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 0
    )));

	$wp_customize->add_setting('header_extra_menu_scrolling_fontsize', array(
        'default'        => '100',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'header_extra_menu_scrolling_fontsize', array(
        'label'      => customize_options_language('Header extra menu font size on scroll', 'Hoofd extra menu lettertype grootte bij scroll'),
        'section'    => 'senhblog_header',
        'settings'   => 'header_extra_menu_scrolling_fontsize',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 100,
		'extra_select_name' => '',
		'extra_select_choices' => array('%' => '%')
    )));

}