<?php

add_filter('nav_menu_link_attributes', 'senhblog_add_default_nofollow_navlinks', 10, 3);
function senhblog_add_default_nofollow_navlinks($atts, $item, $args) {
	if ($args->theme_location == 'footer' || $args->theme_location == 'header-extra') {
		if (!$atts['rel']) {
			// set default nofollow, except for link to sitemap
			if (strpos($atts['href'], '/sitemap') === false) {
				$atts['rel'] = 'nofollow';
			}
		}
	}
	return $atts;
}

add_filter('wp_nav_menu_items', 'senhblog_add_home_text_secondary_menu', 10, 2);
function senhblog_add_home_text_secondary_menu($html, $args) {
    if ('header-primary' == $args->theme_location && get_theme_mod('mainmenu_enable_searchbox', true)) {
		if (get_theme_mod('searchbox_show_on_toggle')) { 
			$search = '';
			ob_start();
			senhblog_template('navbar-searchform');
			$search = ob_get_contents();
			ob_end_clean();

			$html .= '<li class="header-search"><a id="header-search-button" href="javascript:;"><i class="glyphicon glyphicon-search"></i></a><ul class="dropdown-menu"><li>' . $search . '</li></ul></li>';
		}
	}
	return $html;
}

add_filter('wp_nav_menu_items', 'senhblog_add_show_mobile_items', 10, 2);
function senhblog_add_show_mobile_items($html, $args) {
    if ('header-primary' == $args->theme_location) {
		if (get_theme_mod('mainmenu_show_mobile_items', 'no') == 'yes') { 
			$html .= '<li style="position:absolute;right:0px;"><a id="force-show-main-menu-items" href="javascript:;" onclick="jQuery(this).closest(\'ul\').toggleClass(\'force-show-items\');return false;"><i class="glyphicon glyphicon-menu-hamburger"></i></a></li>';
		}
	}
	
	return $html;
}

add_filter('senhblog_navbar_nav_collapse', function($enable_collapse, $theme_location) {
	if ($theme_location == 'header-primary') {
		return get_theme_mod('mainmenu_show_mobile', 'yes') == 'only_toggle';
	} else if ($theme_location == 'header-secondary') {
		return get_theme_mod('submenu_show_mobile', 'yes') == 'only_toggle';
	}
	return $enable_collapse;
}, 10, 2);

add_filter('senhblog_nav_menu_attrs', function($attrs) {
	if ($attrs['theme_location'] == 'header-primary') {
		if ($mainmenu_show_mobile = get_theme_mod('mainmenu_show_mobile', 'yes')) {
			if ($mainmenu_show_mobile == 'no') {
				$attrs['menu_class'] .= ' hidden-xs';
			}
		}
		if (get_theme_mod('mainmenu_display_mobile') == 'list') {
			$attrs['menu_class'] .= ' navbar-block';
		}
	} else if ($attrs['theme_location'] == 'header-secondary') {
		//if ($submenu_show_mobile = get_theme_mod('submenu_show_mobile', 'yes')) {
			//if ($submenu_show_mobile == 'no') {
				// always hide secondary menu on mobile
				$attrs['menu_class'] .= ' hidden-xs';
			//}
		//}
		if (get_theme_mod('submenu_display_mobile') == 'list') {
			$attrs['menu_class'] .= ' navbar-block';
		}
	}
	return $attrs;
});

add_filter('wp_nav_menu_items', 'senhblog_add_home_button_primary_menu', 10, 2);
function senhblog_add_home_button_primary_menu($html, $args) {
    if ('header-primary' !== $args->theme_location) {
        return $html;
    }

	if (get_theme_mod('mainmenu_enable_homebutton')) {
		$homebutton = '<li class="home' . ($_SERVER['REQUEST_URI'] == '/' ? ' active' : '') . '"><a href="' . get_site_url() . '"><i class="glyphicon glyphicon-home"></i></a></li>';
		preg_match_all('!<li.*?>.*?</li>!', $html, $matches);
		foreach ($matches[0] as $m) {
			if (strpos($m, 'href="/"') !== false || strpos($m, 'href="' . get_site_url() . '"') !== false) {
				$html = str_replace($m, $homebutton, $html);
			}
		}
	}

	return $html;
}


add_action('init', 'senhblog_register_menus');
function senhblog_register_menus() {
	register_nav_menus(
		array(
			'header-primary' => 'Main Menu',
			'header-secondary' => 'Main Submenu',
			'footer' => 'Footer Menu',
			'header-extra' => 'Header Menu'
		)
	);
}

function senhblog_nav_menu($name) {
	// 1th check if mennu exists
	if (!has_nav_menu($name)) return;

	// 2nd check if registered menu exists
	$theme_menus = get_theme_mod('nav_menu_locations');
	if (!$theme_menus[$name]) return;

	// 3th check if registerd menu exists
	$menus = get_terms('nav_menu');
	foreach ($menus as $menu) {
		if ($menu->term_id == $theme_menus[$name]) {
			$menu_exists = true;
		}
	}
	if (!isset($menu_exists)) return;

	if ($name == 'header-primary' && !get_theme_mod('layout_mainmenu_enabled', true)) {
		return false;
	} else if ($name == 'header-secondary' && !get_theme_mod('layout_submenu_enabled')) {
		return false;
	} else if ($name == 'header-extra' && !get_theme_mod('layout_extramenu_enabled')) {
		return false;
	}

	$enable_collapse = apply_filters('senhblog_navbar_nav_collapse', false, $name);
?>
<?php if ($enable_collapse) { ?>
<div id="navbar-header-<?php echo $name; ?>" style="position:absolute;top:10px;width:10%;text-align:center;margin:0px;">
	<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-nav-<?php echo $name; ?>" aria-expanded="false" aria-controls="navbar" style="margin:0px;padding:0px;font-size:30px">
		<div class="navbar-toggle-background"></div>
		<span class="sr-only">Toggle navigation</span>
		<span class="glyphicon glyphicon-menu-hamburger" style="margin:5px"></span>
	</button>
</div>
<?php } ?>
<?php
	if ($name == 'header-primary' && get_theme_mod('searchbox_visible', true) && get_theme_mod('mainmenu_enable_searchbox', true) && get_theme_mod('searchbox_visible_mobile') == 'right_search') {
		senhblog_template('navbar-searchform');
	}
?>
<nav id="navbar-<?php echo $name; ?>" class="navbar navbar-<?php echo $name; ?>">
	<div class="container" style="position:static">
		<div id="navbar-nav-<?php echo $name; ?>" class="<?php echo $enable_collapse ? 'navbar-collapse collapse' : ''; ?>">
	<?php
	wp_nav_menu(apply_filters('senhblog_nav_menu_attrs', array(
		'theme_location' => $name,
		//'depth' => 2,
		'container' => false,
		'menu_class' => 'nav navbar-nav',// . ($name == 'header-primary' ? (get_theme_mod('mainmenu_fullwidth') ? ' nav-justified' : ' navbar-nav') : ' navbar-nav'),
		//Process nav menu using our custom nav walker
		'walker' => new wp_bootstrap_navwalker()
	)));

	if ($name == 'header-primary' && get_theme_mod('searchbox_visible', true) && get_theme_mod('mainmenu_enable_searchbox', true) && get_theme_mod('searchbox_visible_mobile') != 'right_search') {
		if (!get_theme_mod('searchbox_show_on_toggle')) {
			senhblog_template('navbar-searchform');
		}
	}
	?>
		</div>
	</div>
</nav>
<?php
}