<?php

add_action('customize_register', 'senhblog_content_customize_register');
function senhblog_content_customize_register($wp_customize) {

    $wp_customize->add_section('senhblog_content', array(
        'title'    => customize_options_language('7. Content', '7. Inhoud'),
        'description' => '',
        'priority' => 126,
    ));

	$wp_customize->add_setting('content_border_width', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_border_width', array(
        'label'      => customize_options_language('Content border width', 'Inhoud omlijning dikte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_border_width',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting('content_border_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_border_color',
		array(
			'label'      => customize_options_language('Content border color', 'Inhoud omlijning kleur') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_border_color'
		)
	));

	$wp_customize->add_setting('content_shadow_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_shadow_color',
		array(
			'label'      => customize_options_language('Content shadow color', 'Inhoud schaduw kleur') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_shadow_color'
		)
	));

	$wp_customize->add_setting('content_background_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_background_color',
		array(
			'label'      => customize_options_language('Content background color', 'Inhoud achtergrond kleur') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_background_color'
		)
	));

	$wp_customize->add_setting('content_padding', array(
        'default'        => 15,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_padding', array(
        'label'      => customize_options_language('Content padding (left and right)', 'Content padding (links en rechts)') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_padding',
		'type'		=> 'number'
    ));

    $wp_customize->add_setting('content_blogheader_padding_top', array(
        'default'        => 0,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_blogheader_padding_top', array(
        'label'      => customize_options_language('Blogheader padding (top)', 'Blogheader padding (top)') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_blogheader_padding_top',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_blogheader_offset_y', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_blogheader_offset_y', array(
        'label'      => customize_options_language('Blogheader offset-Y', 'Blogheader afstand-Y') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_blogheader_offset_y',
		'slider_min' => -100,
		'slider_max' => 100,
		'default' => 0
    )));

	$wp_customize->add_setting('content_featured_image_visible', array(
        'default'        => true,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_featured_image_visible', array(
        'label'      => customize_options_language('Show featured image', 'Uitgelichte afbeelding weergeven'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_featured_image_visible',
		'type'	=> 'checkbox'
    ));

	$wp_customize->add_setting('content_image_position', array(
        'default'        => 'on_first_line',
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_image_position', array(
        'label'      => customize_options_language('Featured image position', 'Uitgelichte afbeelding positie') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_image_position',
		'type'		=> 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'on_first_line' => customize_options_language('On first line', 'Op de eerste regel'))
    ));

	$wp_customize->add_setting('content_image_alignment', array(
        'default'        => 'left',
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_image_alignment', array(
        'label'      => customize_options_language('Featured image alignment', 'Uitgelichte afbeelding uitlijning') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_image_alignment',
		'type'		=> 'select',
		'choices' => array('left' => customize_options_language('Left', 'Links'), 'right' => customize_options_language('Right', 'Rechts'))
    ));

	$wp_customize->add_setting('content_image_width', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_setting('content_image_width_type', array(
        'default'        => '%',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_image_width', array(
        'label'      => customize_options_language('Featured image width', 'Uitgelichte afbeelding breedte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_image_width',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0,
		'extra_select_name' => 'content_image_width_type',
		'extra_select_choices' => array('%' => '%', 'px' => 'px'),
		'extra_select_default' => '%'
    )));

    $wp_customize->add_setting('content_image_height', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_image_height', array(
        'label'      => customize_options_language('Featured image height', 'Uitgelichte afbeelding hoogte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_image_height',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0,
		'extra_select_name' => 'content_image_width_type',
		'extra_select_choices' => array('%' => '%', 'px' => 'px'),
		'extra_select_default' => '%',
		'extra_select_disabled' => true
    )));


	$wp_customize->add_setting('content_image_maxheight', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_image_maxheight', array(
        'label'      => customize_options_language('Featured image maximum height', 'Uitgelichte afbeelding maximum hoogte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_image_maxheight',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting('content_details_fontsize', array(
        'default'        => 14,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_details_fontsize', array(
        'label'      => customize_options_language('Post details font size', 'Artikel details lettertype grootte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_details_fontsize',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting('content_details_margin_top', array(
        'default'        => 0,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_details_margin_top', array(
        'label'      => customize_options_language('Post details (extra) margin top', 'Artikel details (extra) afstand boven') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_details_margin_top',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting('content_details_margin_bottom', array(
        'default'        => 0,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_details_margin_bottom', array(
        'label'      => customize_options_language('Post details (extra) margin onder', 'Artikel details (extra) afstand onder') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_details_margin_bottom',
		'type'	=> 'number'
    ));

	/*$wp_customize->add_setting('content_seperator_post_details', array(
        'default'        => '|',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_seperator_post_details', array(
        'label'      => customize_options_language('Post details seperator', 'Artikel details scheidingsteken') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_seperator_post_details'
    ));

	$wp_customize->add_setting('content_show_gravatar', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_show_gravatar', array(
        'label'      => customize_options_language('Show author gravatar', 'Weergeef auteur avatar'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_gravatar',
		'type'		=> 'checkbox'
    ));*/

	$wp_customize->add_setting('content_gravatar_size', array(
        'default'        => '30',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_gravatar_size', array(
        'label'      => customize_options_language('Gravatar size', 'Avatar grootte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_gravatar_size',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 30
    )));

	$wp_customize->add_setting('content_details_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('content_details_position', array(
		'label'      => customize_options_language('Post details position', 'Artikel details positie') . ':',
		'section'    => 'senhblog_content',
		'settings'   => 'content_details_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));

	/*$wp_customize->add_setting('content_author_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('content_author_position', array(
		'label'      => customize_options_language('Author position', 'Auteur positie'),
		'section'    => 'senhblog_content',
		'settings'   => 'content_author_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));

	$wp_customize->add_setting('content_category_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('content_category_position', array(
		'label'      => customize_options_language('Category position', 'Categorie positie'),
		'section'    => 'senhblog_content',
		'settings'   => 'content_category_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));

	$wp_customize->add_setting('content_date_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('content_date_position', array(
		'label'      => customize_options_language('Date position', 'Datum positie'),
		'section'    => 'senhblog_content',
		'settings'   => 'content_date_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));

	$wp_customize->add_setting('content_comments_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('content_comments_position', array(
		'label'      => customize_options_language('Comments position', 'Reacties positie'),
		'section'    => 'senhblog_content',
		'settings'   => 'content_comments_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));*/

	/*$wp_customize->add_setting('content_show_authorname', array(
        'default'        => true,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_show_authorname', array(
        'label'      => customize_options_language('Show authorname', 'Weergeef auteurnaam'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_authorname',
		'type'		=> 'checkbox'
    ));*/

	/*$wp_customize->add_setting('content_author_prefix', array(
        'default'        => customize_options_language('By:', 'Door:'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_author_prefix', array(
        'label'      => customize_options_language('Authorname prefix', 'Auteurnaam prefix') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_author_prefix'
    ));*/

	/*$wp_customize->add_setting('content_show_category', array(
        'default'        => true,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_show_category', array(
        'label'      => customize_options_language('Show category', 'Weergeef categorie'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_category',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('content_category_prefix', array(
        'default'        => customize_options_language('Category:', 'Categorie:'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_category_prefix', array(
        'label'      => customize_options_language('Category prefix', 'Categorie prefix') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_category_prefix'
    ));

	$wp_customize->add_setting('content_show_date', array(
        'default'        => true,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_show_date', array(
        'label'      => customize_options_language('Show date', 'Weergeef datum'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_date',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('content_show_nrof_comments', array(
        'default'        => true,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_show_nrof_comments', array(
        'label'      => customize_options_language('Show number of comments', 'Weergeef aantal reacties'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_nrof_comments',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('content_text_comments_none', array(
        'default'        => customize_options_language('Response', 'Reageer'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_text_comments_none', array(
        'label'      => customize_options_language('Text comments when no responses', 'Tekst bij reacties als er geen reacties zijn') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_text_comments_none'
    ));

	$wp_customize->add_setting('content_text_comments_one', array(
        'default'        => customize_options_language('1 Response', '1 Reactie'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_text_comments_one', array(
        'label'      => customize_options_language('Text comments when 1 response', 'Tekst bij reacties als er 1 reactie is') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_text_comments_one'
    ));

	$wp_customize->add_setting('content_text_comments_more', array(
        'default'        => customize_options_language('% Responses', '% Reacties'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_text_comments_more', array(
        'label'      => customize_options_language('Text comments when 2 or more responses', 'Tekst bij reacties als er 2 of meer reacties zijn') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_text_comments_more'
    ));*/

	$wp_customize->add_setting('content_link_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_link_color',
		array(
			'label'      => customize_options_language('Link color', 'Link kleur') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_link_color'
		)
	));

	$wp_customize->add_setting('content_link_underlined', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_link_underlined', array(
        'label'      => customize_options_language('Underline links', 'Onderstreep links'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_link_underlined',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('content_link_hover_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_link_hover_color',
		array(
			'label'      => customize_options_language('Link hover color', 'Link hover kleur') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_link_hover_color'
		)
	));

	$wp_customize->add_setting('content_link_hover_underlined', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_link_hover_underlined', array(
        'label'      => customize_options_language('Link hover underline', 'Link hover onderstrepen'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_link_hover_underlined',
		'type'		=> 'checkbox'
    ));

	$themefonts = array();
	$themefonts_path = get_template_directory() . '/themefonts';
	foreach (glob($themefonts_path . '/*.css') as $file) {
		$name = basename($file);
		$themefonts[$name] = current(explode('.', $name));
	}

	$wp_customize->add_setting('content_headings_fontfamily', array(
        'default'        => 'Verdana.css'
    ));
    $wp_customize->add_control('content_headings_fontfamily', array(
        'label'      => customize_options_language('Choose headings font-family:', 'Kies kopjes lettertype:'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_headings_fontfamily',
		'type'	=> 'select',
		'choices'  => $themefonts
    ));

	$wp_customize->add_setting('content_fontsize_h1', array(
        'default'        => '30',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('content_fontsize_h1', array(
        'label'      => customize_options_language('Font size H1', 'Lettertype grootte H1') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontsize_h1',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_color_h1', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_color_h1',
		array(
			'label'      => customize_options_language('Font color H1', 'Tekst kleur H1') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_color_h1'
		)
	));

	$wp_customize->add_setting('content_weight_h1', array(
        'default'        => 'normal',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_weight_h1', array(
        'label'      => customize_options_language('Font weight H1', 'Lettertype dikte H1') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_weight_h1',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	$wp_customize->add_setting('content_fontsize_h2', array(
        'default'        => '25',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('content_fontsize_h2', array(
        'label'      => customize_options_language('Font size H2', 'Lettertype grootte H2') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontsize_h2',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_color_h2', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_color_h2',
		array(
			'label'      => customize_options_language('Font color H2', 'Tekst kleur H2') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_color_h2'
		)
	));

	$wp_customize->add_setting('content_weight_h2', array(
        'default'        => 'normal',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_weight_h2', array(
        'label'      => customize_options_language('Font weight H2', 'Lettertype dikte H2') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_weight_h2',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	$wp_customize->add_setting('content_fontsize_h3', array(
        'default'        => '16',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('content_fontsize_h3', array(
        'label'      => customize_options_language('Font size H3', 'Lettertype grootte H3') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontsize_h3',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_color_h3', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_color_h3',
		array(
			'label'      => customize_options_language('Font color H3', 'Tekst kleur H3') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_color_h3'
		)
	));

	$wp_customize->add_setting('content_weight_h3', array(
        'default'        => 'normal',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_weight_h3', array(
        'label'      => customize_options_language('Font weight H3', 'Lettertype dikte H3') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_weight_h3',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	$wp_customize->add_setting('content_fontsize_h4', array(
        'default'        => '16',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('content_fontsize_h4', array(
        'label'      => customize_options_language('Font size H4', 'Lettertype grootte H4') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontsize_h4',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_color_h4', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_color_h4',
		array(
			'label'      => customize_options_language('Font color H4', 'Tekst kleur H4') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_color_h4'
		)
	));

	$wp_customize->add_setting('content_weight_h4', array(
        'default'        => 'normal',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_weight_h4', array(
        'label'      => customize_options_language('Font weight H4', 'Lettertype dikte H4') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_weight_h4',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	/*$wp_customize->add_setting('content_fontsize_h5', array(
        'default'        => '14',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('content_fontsize_h5', array(
        'label'      => customize_options_language('Font size H5', 'Lettertype grootte H5') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontsize_h5',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_fontsize_h6', array(
        'default'        => '14',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('content_fontsize_h6', array(
        'label'      => customize_options_language('Font size H6', 'Lettertype grootte H6') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontsize_h6',
		'type'		=> 'number'
    ));*/

	/*$wp_customize->add_setting('content_headers_fontfamily', array(
        'default'        => 'Roboto',
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_headers_fontfamily', array(
        'label'      => customize_options_language('Headers font', 'Headers lettertype') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_headers_fontfamily',
		'type'		=> 'select',
		'choices' => array('Arial' => 'Arial', 'Verdana' => 'Verdana', 'Roboto' => 'Roboto')
    ));*/

	$wp_customize->add_setting('content_fontsize_paragraph', array(
        'default'        => '14',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('content_fontsize_paragraph', array(
        'label'      => customize_options_language('Font size paragraph', 'Lettertype grootte paragraaf') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontsize_paragraph',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_fontcolor_paragraph', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_fontcolor_paragraph',
		array(
			'label'      => customize_options_language('Font color paragraph', 'Tekst kleur paragraaf') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_fontcolor_paragraph'
		)
	));

	$wp_customize->add_setting('content_fontweight_paragraph', array(
        'default'        => 'normal',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_fontweight_paragraph', array(
        'label'      => customize_options_language('Font weight paragraph', 'Lettertype dikte paragraaf') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontweight_paragraph',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	$wp_customize->add_setting('content_fontsize_paragraph_mobile', array(
        'default'        => '14',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('content_fontsize_paragraph_mobile', array(
        'label'      => customize_options_language('Font size paragraph on mobile', 'Lettertype grootte paragraaf op mobiel') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_fontsize_paragraph_mobile',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_lineheight_paragraph', array(
        'default'        => '19',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_lineheight_paragraph', array(
        'label'      => customize_options_language('Line height paragraph', 'Regelhoogte paragraaf') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_lineheight_paragraph',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 19
    )));

	/*$wp_customize->add_setting('content_paragraph_margintop', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_paragraph_margintop', array(
        'label'      => customize_options_language('Margin top paragraph', 'Paragraaf afstand boven') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_paragraph_margintop',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 0
    )));*/

	$wp_customize->add_setting('content_paragraph_marginbottom', array(
        'default'        => '10',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_paragraph_marginbottom', array(
        'label'      => customize_options_language('Margin bottom paragraph', 'Paragraaf afstand onder') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_paragraph_marginbottom',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 10
    )));

	$wp_customize->add_setting('content_thickness_bulletpoints', array(
        'default'        => '10',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_thickness_bulletpoints', array(
        'label'      => customize_options_language('Thickness bulletpoints', 'Dikte bulletpoints') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_thickness_bulletpoints',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 10
    )));

	$wp_customize->add_setting('content_color_bulletpoints', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_color_bulletpoints',
		array(
			'label'      => customize_options_language('Color bulletpoints', 'Kleur bulletpoints') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_color_bulletpoints'
		)
	));

	/*$wp_customize->add_setting('content_color_listol', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_color_listol',
		array(
			'label'      => customize_options_language('Color list (ol) numbers', 'Kleur lijst (ol) cijfers') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_color_listol'
		)
	));*/

	$wp_customize->add_setting('content_indent_quote_ol_ul', array(
        'default'        => 26,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_indent_quote_ol_ul', array(
        'label'      => customize_options_language('Pixels indent quote, ol and ul', 'Pixels afstand quote, ol en ul') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_indent_quote_ol_ul',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('content_quote_backgroundcolor', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_quote_backgroundcolor',
		array(
			'label'      => customize_options_language('Quote background color', 'Quote achtergrondkleur') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_quote_backgroundcolor'
		)
	));

	$wp_customize->add_setting('content_quote_italic', array(
        'default'        => true,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_quote_italic', array(
        'label'      => customize_options_language('Quote italic', 'Quote italic'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_quote_italic',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('content_quote_fontsize', array(
        'default'        => 14,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_quote_fontsize', array(
        'label'      => customize_options_language('Quote font-size', 'Quote lettertype grootte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_quote_fontsize',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 14
    )));

	/*$wp_customize->add_setting('content_quote_marginleft', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_quote_marginleft', array(
        'label'      => customize_options_language('Margin left quote', 'Quote afstand links') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_quote_marginleft',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 0
    )));

	$wp_customize->add_setting('content_quote_margintop', array(
        'default'        => '10',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_quote_margintop', array(
        'label'      => customize_options_language('Margin top quote', 'Quote afstand boven') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_quote_margintop',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 10
    )));

	$wp_customize->add_setting('content_quote_marginright', array(
        'default'        => '10',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_quote_marginright', array(
        'label'      => customize_options_language('Margin right quote', 'Quote afstand rechts') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_quote_marginright',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 10
    )));

	$wp_customize->add_setting('content_quote_marginbottom', array(
        'default'        => '10',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'content_quote_marginbottom', array(
        'label'      => customize_options_language('Margin bottom quote', 'Quote afstand onder') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_quote_marginbottom',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 10
    )));*/

	$wp_customize->add_setting('content_show_biography', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_show_biography', array(
        'label'      => customize_options_language('Show biography', 'Biografie weergeven'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_biography',
		'type'		=> 'checkbox'
    ));

    $wp_customize->add_setting('content_about_author', array(
        'default'        => 'Over de auteur',
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_about_author', array(
        'label'      => customize_options_language('About author', 'Over de auteur:'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_about_author'
    ));

	$wp_customize->add_setting('content_show_biography_avatar_size', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_show_biography_avatar_size', array(
        'label'      => customize_options_language('Biography avatar size', 'Biografie avatar grootte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_biography_avatar_size',
		'type' => 'number'
    ));

	$wp_customize->add_setting('content_show_biography_title_fontsize', array(
        'default'        => '16',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_show_biography_title_fontsize', array(
        'label'      => customize_options_language('Biography title font size', 'Biografie titel lettertype grootte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_biography_title_fontsize',
		'type' => 'number'
    ));

	$wp_customize->add_setting('content_show_biography_title_fontcolor', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_show_biography_title_fontcolor',
		array(
			'label'      => customize_options_language('Biography title font color', 'Biografie titel lettertype kleur') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_show_biography_title_fontcolor'
		)
	));

	$wp_customize->add_setting('content_show_biography_borderwidth', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('content_show_biography_borderwidth', array(
        'label'      => customize_options_language('Biography border thickness', 'Biografie omlijning dikte') . ':',
        'section'    => 'senhblog_content',
        'settings'   => 'content_show_biography_borderwidth',
		'type' => 'number'
    ));

	$wp_customize->add_setting('content_show_biography_bordercolor', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'content_show_biography_bordercolor',
		array(
			'label'      => customize_options_language('Biography border color', 'Biografie omlijning kleur') . ':',
			'section'    => 'senhblog_content',
			'settings'   => 'content_show_biography_bordercolor'
		)
	));

	$wp_customize->add_setting('content_youtube_show_related', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('content_youtube_show_related', array(
        'label'      => customize_options_language('Show related youtube video\'s', 'Toon gerelateerde youtube video\'s'),
        'section'    => 'senhblog_content',
        'settings'   => 'content_youtube_show_related',
		'type'		=> 'checkbox'
    ));

}
