<?php

add_action('customize_register', 'senhblog_socialbuttons_customize_register');
function senhblog_socialbuttons_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_socialbuttons', array(
        'title'    => customize_options_language('3. Social media', '3. Social media'),
        'description' => '',
        'priority' => 122,
    ));

	if (!is_plugin_active('sharketing-social-media-buttons/sharketing-social-media-buttons.php')) {
		$wp_customize->add_setting('socialbuttons_ssmb_installtext', array(
			'default'        => ''
		)); 
		$wp_customize->add_control('socialbuttons_ssmb_installtext', array(
			'label'      => 'Sharketing Social Media Buttons plugin not installed!',
			'section'    => 'senhblog_socialbuttons',
			'settings'   => 'socialbuttons_ssmb_installtext'
		));
		return;
	}

	$wp_customize->add_setting('socialbuttons_preline', array(
        'default'        => ''
    )); 
    $wp_customize->add_control('socialbuttons_preline', array(
        'label'      => customize_options_language('Follow us-text:', 'Volg ons-tekst:'),
        'section'    => 'senhblog_socialbuttons',
        'settings'   => 'socialbuttons_preline'
    ));

	$wp_customize->add_setting('socialbuttons_enabled', array(
        'default'        => false
    )); 
    $wp_customize->add_control('socialbuttons_enabled', array(
        'label'      => customize_options_language('Show social media buttons', 'Social media knoppen weergeven'),
        'section'    => 'senhblog_socialbuttons',
        'settings'   => 'socialbuttons_enabled',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('socialbuttons_size', array(
        'default'        => '40',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'socialbuttons_size', array(
        'label'      => customize_options_language('Social buttons size', 'Social media knoppen grootte') . ':',
        'section'    => 'senhblog_socialbuttons',
        'settings'   => 'socialbuttons_size',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 40
    )));

	$wp_customize->add_setting('socialbuttons_margin', array(
        'default'        => '4',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'socialbuttons_margin', array(
        'label'      => customize_options_language('Social buttons margin', 'Social media knoppen (tussen) afstand') . ':',
        'section'    => 'senhblog_socialbuttons',
        'settings'   => 'socialbuttons_margin',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 4
    )));	

}