<?php
	
add_filter('theme_mod_layout_container_width', function($width) {
	$override_site_width = get_post_meta(senhblog_get_queried_post()->ID, '_senhblog_site_width', true);
	if ($override_site_width > 0) {
		return $override_site_width;
	}
	return $width;
});
	

function senhblog_site_width_add_custom_box() {
    $screens = array( 'page', 'post' );
    foreach ($screens as $screen) {
        add_meta_box(
            'senhblog_post_details_metaid',
            __('Site width for this page', 'senhblog'),
            'senhblog_site_with_custom_box',
            $screen
        );
    }
}

function senhblog_site_with_custom_box($post) {
	wp_nonce_field( plugin_basename( __FILE__ ), 'senhblog_spd_noncename' );
	$senhblog_site_width = get_post_meta($post->ID, '_senhblog_site_width', true);
?>
<div><label><input type="number" name="senhblog_site_width" value="<?php echo $senhblog_site_width; ?>" placeholder="<?php echo get_theme_mod('layout_container_width') ;?>"> Override site width.</label></div>
<?php	
}

function senhblog_site_width_save_postdata( $post_id ) {
	if ( 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) return;
	}
	
	if ( ! isset( $_POST['senhblog_spd_noncename'] ) || ! wp_verify_nonce( $_POST['senhblog_spd_noncename'], plugin_basename( __FILE__ ) ) )
		return;
	
	$val = $_POST['senhblog_site_width'];
	add_post_meta($post_id, '_senhblog_site_width', $val, true) or update_post_meta($post_id, '_senhblog_site_width', $val);
}

add_action('add_meta_boxes', 'senhblog_site_width_add_custom_box');
add_action('save_post', 'senhblog_site_width_save_postdata');
