<?php
	
function senhtheme_get_menu_items() {
	$menu_items = array();
	$locations = get_nav_menu_locations();
	foreach ($locations as $location => $menu_id) {
		$items = wp_get_nav_menu_items($menu_id);
		if (is_array($items)) {
			foreach ($items as $item) {
				$menu_items[] = $item;
			}
		}
	}
	return $menu_items;
}	
	
add_action('admin_footer', function() {
	$menu_items_hide_on_mobile = get_option('menu_items_hide_on_mobile', array());
	$menu_items = senhtheme_get_menu_items();
	$menu_items = array_map(function($menu_item) {
		return (object) array('id' => $menu_item->ID);
	}, $menu_items);
	foreach ($menu_items as &$menu_item) {
		$menu_item->hide_on_mobile = $menu_items_hide_on_mobile[$menu_item->id];
	}
?>
<script>
	(function($) {
		var menu_items = <?php echo json_encode($menu_items); ?>;
		$.each(menu_items, function() {
			$('#menu-item-' + this.id + ' .field-link-target').after('<p class="field-link-target description field-hide-on-mobile"><label for="hide-on-mobile-' + this.id + '"><input type="hidden" value="" name="menu-item-hide-mobile[' + this.id + ']"><input type="checkbox" id="hide-on-mobile-' + this.id + '" value="1" name="menu-item-hide-mobile[' + this.id + ']" ' + (this.hide_on_mobile ? 'checked' : '') + '> Verbergen op mobiel</label></p>');
		});
		$(document).on('mouseover', '.menu-item', function() {
			if ($(this).find('.field-hide-on-mobile').length > 0) 
				return;
				
			var id = $(this).attr('id').split('-')[2];
				
			$('#menu-item-' + id + ' .field-link-target').after('<p class="field-link-target description field-hide-on-mobile"><label for="hide-on-mobile-' + id + '"><input type="hidden" value="" name="menu-item-hide-mobile[' + id + ']"><input type="checkbox" id="hide-on-mobile-' + id + '" value="1" name="menu-item-hide-mobile[' + id + ']"> Verbergen op mobiel</label></p>');
		});
	})(jQuery);
</script>	
<?php	
});

add_action('wp_update_nav_menu', 'senhtheme_save_menu_options');
function senhtheme_save_menu_options($nav_menu_selected_id) {
	$menu_items_hide_on_mobile = get_option('menu_items_hide_on_mobile', array());
    $items = wp_get_nav_menu_items($nav_menu_selected_id);
    foreach ($_POST['menu-item-hide-mobile'] as $id => $val) {
	    $menu_items_hide_on_mobile[$id] = $val;
	}
	senhblog_wp_set_option('menu_items_hide_on_mobile', $menu_items_hide_on_mobile);
}

add_action('senhtheme_customize_css', 'sentheme_hide_menu_options');
function sentheme_hide_menu_options() {
	$hide_menu_items = array();
	$menu_items_hide_on_mobile = get_option('menu_items_hide_on_mobile', array());
	foreach ($menu_items_hide_on_mobile as $menu_item_id => $hide) {
		if ($hide) {
			$hide_menu_items[] = '#menu-item-' . $menu_item_id;
		}
	}
	if (!empty($hide_menu_items)) {
		echo '@media screen and (max-width: 480px){' . implode(',', $hide_menu_items) . '{display:none;}}';
	}
	
	echo '@media screen and (min-width: 480px){#force-show-main-menu-items{display:none;}}';
}