<?php

function sidebar_widget_init() {
	register_sidebar(array(
		'name'          => 'Sidebar',
		'id'            => 'sidebar',
		'before_widget' => '<div class="widget-container"><div class="widget-content">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	));
}
add_action('widgets_init', 'sidebar_widget_init');

function belowheader_widget_init() {
	register_sidebar(array(
		'name'          => 'Below Header',
		'id'            => 'below-header-full',
		'before_widget' => '<div class="fullwidget">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
	));
}
add_action('widgets_init', 'belowheader_widget_init');

function abovefooter_widget_init() {
	register_sidebar(array(
		'name'          => 'Above Footer',
		'id'            => 'above-footer-full',
		'before_widget' => '<div class="fullwidget">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
	));
}
add_action('widgets_init', 'abovefooter_widget_init');

function promotion_widget_init() {
	register_sidebar(array(
		'name'          => 'Promotion',
		'id'            => 'promotion-widget',
		'before_widget' => '<div class="widget lightgray-bg">',
		'after_widget'  => '</div>',
		'before_title'  => '',
		'after_title'   => '',
	));
}
add_action('widgets_init', 'promotion_widget_init');

function footer_widget_init() {
	register_sidebar(array(
		'name'          => 'Footer',
		'id'            => 'footer',
		'before_widget' => '<div class="widget"><div class="widget-content"><div class="seperator"></div><div class="row"><div class="col-md-12">',
		'after_widget'  => '</div></div></div></div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	));
}
add_action('widgets_init', 'footer_widget_init');

function tracking_widget_init() {
	register_sidebar(array(
		'name'          => 'Tracking',
		'id'            => 'tracking',
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => '',
	));
}
add_action('widgets_init', 'tracking_widget_init');


return;

class Social_Buttons_Widget extends WP_Widget { 
	public function __construct() {
		$widget_ops = array('classname' => 'Social_Buttons_Widget', 'description' => 'Displays social buttons.' );
		$this->WP_Widget('Social_Buttons_Widget', 'Social Buttons Widget', $widget_ops);
	}
 
	function widget($args, $instance) {
		echo '<div class="row"><div class="col-md-4 col-offset-md-4">';
		senhblog_social_footer_buttons();
		echo '</div></div>';
	}
}
add_action('widgets_init', create_function('', 'return register_widget("Social_Buttons_Widget");'));


 
class My_Widget extends WP_Widget {
 
  public function __construct() {
	  $widget_ops = array('classname' => 'My_Widget', 'description' => 'Displays calls WP Bannerize().' );
	  $this->WP_Widget('WP_Bannerize_Widget', 'WP Bannerize', $widget_ops);
  }
 
  function widget($args, $instance) {
	  wp_bannerize();
	  return;
	extract($args, EXTR_SKIP);
	$wp_bannerize_code = empty($instance['wp_bannerize_code']) ? '' : $instance['wp_bannerize_code'];   
	echo $wp_bannerize_code;
  }
 
  public function form($instance) {   
	  return;
	 // PART 1: Extract the data from the instance variable
	 $instance = wp_parse_args( (array) $instance, array( 'wp_bannerize_code' => '' ) );
	 $wp_bannerize_code = $instance['wp_bannerize_code'];
   
	 // PART 2-3: Display the fields
	 ?>
	 <!-- PART 2: Widget Title field START -->
	 <p>
	  <label for="<?php echo $this->get_field_id('wp_bannerize_code'); ?>">WP Bannerize Code:
		<input class="widefat" id="<?php echo $this->get_field_id('wp_bannerize_code'); ?>"
			   name="<?php echo $this->get_field_name('title'); ?>" type="text"
			   value="<?php echo attribute_escape($wp_bannerize_code); ?>" />
	  </label>
	  </p>
	  <!-- Widget Title field END -->
	 <?php
   
  }
 
  function update($new_instance, $old_instance) {
	$instance = $old_instance;
	$instance['wp_bannerize_code'] = $new_instance['wp_bannerize_code'];
	return $instance;
  }
 
} 

if(function_exists('wp_bannerize')) {
	add_action('widgets_init', create_function('', 'return register_widget("My_Widget");'));
}
