<?php
// create comment form hmtl
ob_start();
comment_form(array('class_submit' => 'btn ' . (get_theme_mod('comments_response_button_style', 'default') == 'default' ? 'btn-primary' : ''), 'title_reply' => get_theme_mod('comments_give_response_text', 'Geef een reactie:'))); 
$comment_form = str_replace('h3', 'h4', ob_get_clean());

// add comment form after reply link, only if replying
add_filter('comment_reply_link', function($link) use ($comment_form) {
	return $link . (isset($_GET['replytocom']) && get_comment_ID() == $_GET['replytocom'] ? $comment_form : '');
});

?>
			
			<div id="comments">
<?php  if ( post_password_required() ) : // don't display comments for password-protected posts ?>
				<p class="nopassword"><?php _e( 'This post is password protected. Enter the password to view any comments.'); ?></p>
			</div><!-- #comments -->
<?php
		return;
	endif;
?>

<?php if ( have_comments() ) : ?>


<h4><?php comments_number(get_theme_mod('blog_post_text_comments_none', 'Reageer'), get_theme_mod('blog_post_text_comments_one', '1 Reactie'), str_replace('[num]', '%', get_theme_mod('blog_post_text_comments_more', "[num] Reacties"))); ?> op <em>"<?php the_title(); ?>"</em> <?php if ( ! comments_open() ) { ?> <small></small><?php } ?></h4>


<?php $i = 0; ?>

<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // If the paged comments setting is enabled, and enough comments exisst to cause comments to be paged ?>
			<div class="navigation">
				<div class="nav-previous"><?php previous_comments_link( '<span class="meta-nav">&larr;</span> Older Comments' ); ?></div>
				<div class="nav-next"><?php next_comments_link( 'Newer Comments <span class="meta-nav">&rarr;</span>' ); ?></div>
			</div> <!-- .navigation -->
<?php endif; // check for comment navigation 
		
		if ( get_comments_number() > '0' ) { ?>
			<ol class="commentlist">
				<?php wp_list_comments('type=comment&callback=senhblog_comment_template'); ?>
			</ol>
		<?php }

		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
			<div class="navigation">
				<div class="nav-previous"><?php previous_comments_link( '<span class="meta-nav">&larr;</span> Older Comments' ); ?></div>
				<div class="nav-next"><?php next_comments_link( 'Newer Comments <span class="meta-nav">&rarr;</span>' ); ?></div>
			</div><!-- .navigation -->
<?php endif; // check for comment navigation ?>

<?php else : // or, if we don't have comments:

endif; // end have_comments() 

// print comment form at bottom when not replying
if (!isset($_GET['replytocom'])) {
	echo $comment_form;
}
?>

<script>
(function($) {
	document.getElementById('comment').className = 'form-control';

	function order_commentfields(order) {
		order.reverse();
		var commentform = $('#commentform');
		$.each(order, function() {
			var el = commentform.find('.comment-form-' + this);
			if (el.length) {
				el.insertAfter(commentform.find('.comment-notes'));
			}
		});
	}
	order_commentfields(['author', 'email', 'comments']);
})(jQuery);
</script>

<style>#form-allowed-tags { display: none; }</style>

</div><!-- #comments -->