<?php

add_action('customize_register', 'senhblog_sidebar_customize_register');
function senhblog_sidebar_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_sidebar', array(
        'title'    => customize_options_language('8. Sidebar', '8. Zijbar'),
        'description' => '',
        'priority' => 127,
    ));

	$wp_customize->add_setting('sidebar_margin_widgets', array(
        'default'        => '20',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'sidebar_margin_widgets', array(
        'label'      => customize_options_language('Margin widgets', 'Afstand tussen widgets') . ':',
        'section'    => 'senhblog_sidebar',
        'settings'   => 'sidebar_margin_widgets',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 20
    )));

	$wp_customize->add_setting('sidebar_bordersize', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('sidebar_bordersize', array(
        'label'      => customize_options_language('Border widgets thickness', 'Rand widgets dikte') . ':',
        'section'    => 'senhblog_sidebar',
        'settings'   => 'sidebar_bordersize',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting('sidebar_bordercolor', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'sidebar_bordercolor',
		array(
			'label'      => customize_options_language('Sidebar widgets border color', 'Zijbar widgets randkleur') . ':',
			'section'    => 'senhblog_sidebar',
			'settings'   => 'sidebar_bordercolor'
		)
	));

	$wp_customize->add_setting('sidebar_widgets_shadow', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'sidebar_widgets_shadow',
		array(
			'label'      => customize_options_language('Sidebar widgets shadow color', 'Zijbar widgets schaduw kleur') . ':',
			'section'    => 'senhblog_sidebar',
			'settings'   => 'sidebar_widgets_shadow'
		)
	));

	$wp_customize->add_setting('sidebar_backgroundcolor', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'sidebar_backgroundcolor',
		array(
			'label'      => customize_options_language('Sidebar background color', 'Zijbar achtergrondkleur') . ':',
			'section'    => 'senhblog_sidebar',
			'settings'   => 'sidebar_backgroundcolor'
		)
	));

	$wp_customize->add_setting('sidebar_widget_title_backgroundcolor', array(
		'default' => '',
		'transport'	=> 'postMessage'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'sidebar_widget_title_backgroundcolor',
		array(
			'label'      => customize_options_language('Sidebar widgets title background color', 'Zijbar widgets titel achtergrond kleur') . ':',
			'section'    => 'senhblog_sidebar',
			'settings'   => 'sidebar_widget_title_backgroundcolor'
		)
	));

	$wp_customize->add_setting('sidebar_widget_title_fontsize', array(
        'default'        => '18',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('sidebar_widget_title_fontsize', array(
        'label'      => customize_options_language('Sidebar widgets title font size', 'Zijbar widgets titel lettertype grootte') . ':',
        'section'    => 'senhblog_sidebar',
        'settings'   => 'sidebar_widget_title_fontsize',
		'type'	=> 'number'
    ));	

	$wp_customize->add_setting('sidebar_widget_title_fontweight', array(
        'default'        => 'normal',
        'transport'     => 'postMessage'
    )); 
    $wp_customize->add_control('sidebar_widget_title_fontweight', array(
        'label'      => customize_options_language('Sidebar widgets title font weight', 'Zijbar widgets titel lettertype dikte') . ':',
        'section'    => 'senhblog_sidebar',
        'settings'   => 'sidebar_widget_title_fontweight',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	$wp_customize->add_setting('sidebar_widget_fontsize', array(
        'default'        => '13',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('sidebar_widget_fontsize', array(
        'label'      => customize_options_language('Sidebar widgets font size', 'Zijbar widgets lettertype grootte') . ':',
        'section'    => 'senhblog_sidebar',
        'settings'   => 'sidebar_widget_fontsize',
		'type'	=> 'number'
    ));	

	$wp_customize->add_setting('sidebar_fontcolor_widget_head', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'sidebar_fontcolor_widget_head',
		array(
			'label'      => customize_options_language('Font color widget head', 'Lettertype kleur widget hoofd') . ':',
			'section'    => 'senhblog_sidebar',
			'settings'   => 'sidebar_fontcolor_widget_head'
		)
	));

	/*$wp_customize->add_setting('sidebar_fontfamily_widget_head', array(
        'default'        => 'Verdana',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('sidebar_fontfamily_widget_head', array(
        'label'      => customize_options_language('Font family widget head', 'Lettertype widget head') . ':',
        'section'    => 'senhblog_sidebar',
        'settings'   => 'sidebar_fontfamily_widget_head',
		'type'		=> 'select',
		'choices' => array('Arial' => 'Arial', 'Verdana' => 'Verdana')
    ));*/

}