<?php

add_filter('senhblog_is_visible', function($visible, $el) {
	$post = senhblog_get_queried_post();
	if (!empty($post) && is_singular($post->post_type)) {
		if ($el == 'post_details') {
			if ($spd = get_post_meta($post->ID, '_senhblog_show_post_details', true)) {
				return true;
			}
		}
	}
	return $visible;
}, 99, 2);

function senhblog_show_post_details_add_custom_box() {
    $screens = array( 'page' );
    foreach ($screens as $screen) {
        add_meta_box(
            'senhblog_show_post_details_metaid',
            __('Show post-details for this page', 'senhblog'),
            'senhblog_show_post_details_custom_box',
            $screen
        );
    }
}

function senhblog_show_post_details_custom_box($post) {
	wp_nonce_field( plugin_basename( __FILE__ ), 'senhblog_spd_noncename_show_post_details' );
	$senhblog_show_post_details = get_post_meta($post->ID, '_senhblog_show_post_details', true);
?>
<div><label><input type="checkbox" name="senhblog_show_post_details" <?php checked(!!$senhblog_show_post_details); ?>>Show same post-details also shown on a post-page.</label></div>
<?php
}

function senhblog_show_post_details_save_postdata( $post_id ) {
	if ( 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) return;
	}

	if ( ! isset( $_POST['senhblog_spd_noncename_show_post_details'] ) || ! wp_verify_nonce( $_POST['senhblog_spd_noncename_show_post_details'], plugin_basename( __FILE__ ) ) )
		return;

	$val = $_POST['senhblog_show_post_details'];
	add_post_meta($post_id, '_senhblog_show_post_details', $val, true) or update_post_meta($post_id, '_senhblog_show_post_details', $val);
}

add_action('add_meta_boxes', 'senhblog_show_post_details_add_custom_box');
add_action('save_post', 'senhblog_show_post_details_save_postdata');
