<?php

if (!function_exists('senhblog_post_cover_and_details')) {
	
	// remove rich snippet in preview
	remove_filter('the_content','display_rich_snippet');
	
	function senhblog_post_cover_and_details($image_position) {

		if ($image_position == 'below_title') {

			// when no metaions above title, put edit below title
			$metaicons_abovetitle = get_theme_mod('blog_post_details_order_above_title', 'author,category,date,comments');
			foreach (explode(',', $metaicons_abovetitle) as $icon) {
				
				if (!get_theme_mod('blog_post_show_' . $icon) || get_theme_mod('blog_post_' . $icon . '_position') == 'below_title') {
					
					$metaicons_abovetitle = str_replace($icon, '', $metaicons_abovetitle);
				}
			}
			
			$metaicons = array();

			$c = explode(',', get_theme_mod('blog_post_details_order_below_title', 'author,category,date,comments'));
			foreach ($c as $icon) {
				
				if (get_theme_mod('blog_post_show_' . $icon) && get_theme_mod('blog_post_' . $icon . '_position') == 'below_title') {
					
					$metaicons []= $icon;
				}
			}

			// when no metaions above title, put edit below title
			if (!str_replace(',','',$metaicons_abovetitle)) {
			
				$metaicons []= 'edit';
				
				if (get_theme_mod('blog_post_show_avatar', true)) {
				
					$metaicons[] = 'avatar';
				}
			}

			if (count($metaicons) > 0) {
			
				?>
				
					<div class="home-post-details">
						
						<?php
						
							if (function_exists('get_field') && get_field('show_new_metadata_format', 'option')) {
								
								set_new_post_details();
							}else{
								
								senhblog_metadata_icons(join($metaicons, ','), '', get_theme_mod('blog_post_seperator_post_details', '|'));
							}
						
						?>
						
					</div>
				
				<?php
			}
		}

		if (get_theme_mod('blog_show_post_images', true) && get_theme_mod('blog_featured_image_position', 'above_title') == $image_position) {
			
			?>
			
			<?php 
				
				if (has_post_thumbnail() == 'above_title') {
					
					?>
						<div class="home-post-cover">
							
							<a href="<?php the_permalink(); ?>">
							
								<?php the_post_thumbnail(senhblog_get_closest_thumbnail_size(senhblog_blog_featured_image_width()),array('class' => 'post-featured-image')); ?>
							
							</a>
						
						</div>
					
					<?php 
				} 
				
			?>
			
			<?php
		}

		if ((get_theme_mod('blog_featured_image_position') != 'at_first_line' && get_theme_mod('blog_featured_image_position', 'above_title') == $image_position) || (get_theme_mod('blog_featured_image_position') == 'at_first_line' && $image_position == 'below_title')) {

			// when no metaions above title, dont put edit above title
			$metaicons = get_theme_mod('blog_post_details_order_above_title', 'author,category,date,comments');
			foreach (explode(',', $metaicons) as $icon) {
				
				if (!get_theme_mod('blog_post_show_' . $icon) || get_theme_mod('blog_post_' . $icon . '_position') == 'below_title') {
					
					$metaicons = str_replace($icon, '', $metaicons);
				}
			}

			if (str_replace(',','',$metaicons)) {
			
				?>

					<div class="home-post-details" qqqqqq>
					
						<?php
						
							if (function_exists('get_field') && get_field('show_new_metadata_format', 'option')) {
							
								set_new_post_details();
								
							} else {
							
								$metaicons = $metaicons . ',edit';
								if (get_theme_mod('blog_post_show_avatar', true)) {
								
									$metaicons = 'avatar,' . $metaicons;
								}
								senhblog_metadata_icons($metaicons, '', get_theme_mod('blog_post_seperator_post_details', '|'));
							}
							
						?>
						
					</div>
					
				<?php
				
			}
		}

	}
}


?>
<div class="home-post">
	<?php senhblog_post_cover_and_details('above_title'); ?>
	<h1 class="home-post-title" <?php function_exists('prologue_show_gravatar_post') ? 'style="margin-top:19px;"' : ''; ?>>
		<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
	</h1>
	
	<?php senhblog_post_cover_and_details('below_title'); ?>
	
	<?php if (get_theme_mod('blog_post_show_description', true)) { ?>
	
	<div class="home-post-description"><?php senhblog_post_cover_and_details('at_first_line'); ?>
		
		<?php echo senhblog_post_description($post); ?>
	</div>
	
	<?php } ?>
	<?php if ($link_type = get_theme_mod('blog_post_show_readmore', 'button')) { ?>
	
	<div class="home-post-more">
		<a class="<?php if ($link_type == 'button') { echo 'btn'; if (get_theme_mod('blog_post_readmore_style', 'default') == 'default') { ?>btn-primary<?php } } ?> click-more" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo get_theme_mod('blog_post_readmore_text', 'Naar artikel'); ?></a>
	</div>
	
	<?php } ?>
	
</div>