<?php

require_once(DIR_SYSTEM . 'engine/neoseo_controller.php');
require_once(DIR_SYSTEM . 'engine/neoseo_view.php');
require_once(DIR_SYSTEM . "library/SassCompiler.php");

class ControllerExtensionThemeNeoseoFirestore extends NeoSeoController {
	private $error = array();

	private $DESKTOP = 'desktop';
	private $PORTABLE = 'portable';

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_moduleSysName = 'neoseo_firestore';
		$this->_module_code = 'neoseo_firestore_free';
		$this->_modulePostfix = ""; // Постфикс для разных типов модуля, поэтому переходим на испольлзование $this->_moduleSysName()
		$this->_logFile = $this->_moduleSysName() . '.log';
		$this->debug = $this->config->get($this->_moduleSysName() . '_debug') == 1;

	}

	public function index()
	{
		$this->upgrade();
		$data = $this->load->language('extension/theme/'.$this->_moduleSysName);
		$data['sysname'] = $this->_moduleSysName;
		$this->document->setTitle($this->language->get('heading_title_raw'));

		$this->document->addStyle('view/stylesheet/' . $data['sysname'] . '.css');
		$this->document->addStyle('view/javascript/coloring-pick/jquery.coloring-pick.min.js.css');
		$this->document->addScript('view/javascript/coloring-pick/jquery.coloring-pick.min.js');

		$this->load->model('setting/setting');
		$this->load->model('localisation/language');

		if(!isset($this->request->get['store_id'])){
			$this->request->get['store_id'] = 0;
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('theme_'.$this->_moduleSysName(), $this->request->post, $this->request->get['store_id']);
			$this->model_setting_setting->editSetting($this->_moduleSysName(), $this->request->post, $this->request->get['store_id']);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->updateColors();
			$this->response->redirect($this->url->link('extension/theme/'.$this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . '&store_id='.$this->request->get['store_id'], true));
		}

		$this->load->model("extension/" . $this->_route . "/" . $this->_moduleSysName());
		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else if (isset($this->session->data['error_warning'])) {
			$data['error_warning'] = $this->session->data['error_warning'];
			unset($this->session->data['error_warning']);
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['product_limit'])) {
			$data['error_product_limit'] = $this->error['product_limit'];
		} else {
			$data['error_product_limit'] = '';
		}

		if (isset($this->error['product_description_length'])) {
			$data['error_product_description_length'] = $this->error['product_description_length'];
		} else {
			$data['error_product_description_length'] = '';
		}

		if (isset($this->error['image_category'])) {
			$data['error_image_category'] = $this->error['image_category'];
		} else {
			$data['error_image_category'] = '';
		}
		
		if (isset($this->error['image_manufacturer'])) {
			$data['error_image_manufacturer'] = $this->error['image_manufacturer'];
		} else {
			$data['error_image_manufacturer'] = '';
		}

		if (isset($this->error['image_thumb'])) {
			$data['error_image_thumb'] = $this->error['image_thumb'];
		} else {
			$data['error_image_thumb'] = '';
		}

		if (isset($this->error['image_popup'])) {
			$data['error_image_popup'] = $this->error['image_popup'];
		} else {
			$data['error_image_popup'] = '';
		}

		if (isset($this->error['image_product'])) {
			$data['error_image_product'] = $this->error['image_product'];
		} else {
			$data['error_image_product'] = '';
		}

		if (isset($this->error['image_additional'])) {
			$data['error_image_additional'] = $this->error['image_additional'];
		} else {
			$data['error_image_additional'] = '';
		}

		if (isset($this->error['image_related'])) {
			$data['error_image_related'] = $this->error['image_related'];
		} else {
			$data['error_image_related'] = '';
		}

		if (isset($this->error['image_compare'])) {
			$data['error_image_compare'] = $this->error['image_compare'];
		} else {
			$data['error_image_compare'] = '';
		}

		if (isset($this->error['image_wishlist'])) {
			$data['error_image_wishlist'] = $this->error['image_wishlist'];
		} else {
			$data['error_image_wishlist'] = '';
		}

		if (isset($this->error['image_cart'])) {
			$data['error_image_cart'] = $this->error['image_cart'];
		} else {
			$data['error_image_cart'] = '';
		}

		if (isset($this->error['image_location'])) {
			$data['error_image_location'] = $this->error['image_location'];
		} else {
			$data['error_image_location'] = '';
		}
		
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=theme', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title_raw'),
			'href' => $this->url->link('extension/theme/'.$this->_moduleSysName, 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true)
		);

		$data['action'] = $this->url->link('extension/theme/'.$this->_moduleSysName, 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=theme', true);
		$data = $this->initParamsListEx($this->{"model_extension_" . $this->_route . "_" . $this->_moduleSysName()}->getParams(), $data);

		if (isset($this->request->get['store_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$setting_info = $this->model_setting_setting->getSetting('theme_'.$this->_moduleSysName(), $this->request->get['store_id']);
		}

		foreach ($setting_info as $k=>$v){
			$data[$k] = $v;
		}
		$data = $this->{"model_extension_" . $this->_route . "_" . $this->_moduleSysName()}->initThemeParams($data);
		//echo "<pre>";print_r($data);exit;
		if (isset($this->request->post['theme_'.$this->_moduleSysName().'_directory'])) {
			$data['theme_'.$this->_moduleSysName().'_directory'] = $this->request->post['theme_'.$this->_moduleSysName().'_directory'];
		} elseif (isset($setting_info['theme_'.$this->_moduleSysName().'_directory'])) {
			$data['theme_'.$this->_moduleSysName().'_directory'] = $setting_info['theme_'.$this->_moduleSysName().'_directory'];
		} else {
			$data['theme_'.$this->_moduleSysName().'_directory'] = $this->_moduleSysName();
		}

		$data['languages'] = $this->model_localisation_language->getLanguages();

		$data['directories'] = array();

		$directories = glob(DIR_CATALOG . 'view/theme/*', GLOB_ONLYDIR);

		foreach ($directories as $directory) {
			$data['directories'][] = basename($directory);
		}

		$this->load->model('tool/neoseo_menu');

		$menus = $this->model_tool_neoseo_menu->getMenus();
		if(!is_array($menus)) {
			$menus = array();
		}
		$data['menus'] = array(0 => $data['entry_not_chosen']);
		foreach ($menus as $menu){
			$data['menus'][$menu['menu_id']] = $menu['title'];
		}

		$data['extensions'] = array();
		$this->load->model('setting/extension');
		$this->load->model('setting/module');
		// Get a list of installed modules
		$extensions = $this->model_setting_extension->getInstalled('module');
		$in_layout_extensions = $this->{"model_extension_" . $this->_route . "_" . $this->_moduleSysName()}->getLayoutModules();
		// Add all the modules which have multiple settings for each module
		foreach ($extensions as $code) {
			if(!in_array($code,$in_layout_extensions)) continue;
			$this->load->language('extension/module/' . $code, 'extension');
			$module_data = array();
			$modules = $this->model_setting_module->getModulesByCode($code);
			foreach ($modules as $module) {
				$module_data[] = array(
					'name' => strip_tags($module['name']),
					'code' => $code . '.' .  $module['module_id']
				);
			}
			if ($this->config->has('module_' . $code . '_status') || $module_data) {
				$data['extensions'][] = array(
					'name'   => strip_tags($this->language->get('extension')->get('heading_title')),
					'code'   => $code,
					'module' => $module_data
				);
			}
		}

		$data['ckeditor'] = ($this->config->get('config_editor_default')  == 'CKEditor');
		//CKEditor
		if ($data['ckeditor']) {
			$this->document->addScript('view/javascript/ckeditor/ckeditor.js');
			$this->document->addScript('view/javascript/ckeditor/ckeditor_init.js');
		} else {
			$this->document->addScript('view/javascript/summernote/summernote.js');
			$this->document->addScript('view/javascript/summernote/lang/summernote-' . $this->language->get('lang') . '.js');
			$this->document->addScript('view/javascript/summernote/summernote-image-attributes.js');
			$this->document->addScript('view/javascript/summernote/opencart.js');
			$this->document->addStyle('view/javascript/summernote/summernote.css');
		}

		$this->document->addStyle('view/stylesheet/tristate.css');
		//echo "<pre>";print_r($data);exit;
		$widgets = new NeoSeoWidgets('theme_' . $this->_moduleSysName() . '_', $data);
		$widgets->text_select_all = $this->language->get('text_select_all');
		$widgets->text_unselect_all = $this->language->get('text_unselect_all');
		$data['widgets'] = $widgets;

		$s_widgets = new NeoSeoWidgets($this->_moduleSysName() . '_', $data);
		$s_widgets->text_select_all = $this->language->get('text_select_all');
		$s_widgets->text_unselect_all = $this->language->get('text_unselect_all');
		$data['s_widgets'] = $s_widgets;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/theme/'.$this->_moduleSysName, $data));
	}

	protected function validate()
	{
		if(!$this->validateKey()){
			$this->response->redirect($this->url->link('extension/theme/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'], 'SSL'));
			return false;
		}

		if (!$this->user->hasPermission('modify', 'extension/theme/'.$this->_moduleSysName)) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		if (isset($this->request->post[$this->_moduleSysName().'_module_key'])) {
			$this->load->model("extension/" . $this->_route . "/" . $this->_moduleSysName());
			$this->{"model_extension_" . $this->_route . "_" . $this->_moduleSysName()}->setModuleKey($this->request->post,$this->request->get['store_id']);
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_product_limit']) || !$this->request->post['theme_'.$this->_moduleSysName().'_product_limit']) {
			$this->error['product_limit'] = $this->language->get('error_limit');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_product_description_length']) || !$this->request->post['theme_'.$this->_moduleSysName().'_product_description_length']) {
			$this->error['product_description_length'] = $this->language->get('error_limit');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_category_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_category_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_category_height']) {
			$this->error['image_category'] = $this->language->get('error_image_category');
		}
		
		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_manufacturer_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_manufacturer_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_manufacturer_height']) {
			$this->error['image_manufacturer'] = $this->language->get('error_image_manufacturer');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_thumb_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_thumb_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_thumb_height']) {
			$this->error['image_thumb'] = $this->language->get('error_image_thumb');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_popup_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_popup_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_popup_height']) {
			$this->error['image_popup'] = $this->language->get('error_image_popup');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_product_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_product_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_product_height']) {
			$this->error['image_product'] = $this->language->get('error_image_product');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_additional_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_additional_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_additional_height']) {
			$this->error['image_additional'] = $this->language->get('error_image_additional');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_related_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_related_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_related_height']) {
			$this->error['image_related'] = $this->language->get('error_image_related');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_compare_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_compare_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_compare_height']) {
			$this->error['image_compare'] = $this->language->get('error_image_compare');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_wishlist_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_wishlist_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_wishlist_height']) {
			$this->error['image_wishlist'] = $this->language->get('error_image_wishlist');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_cart_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_cart_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_cart_height']) {
			$this->error['image_cart'] = $this->language->get('error_image_cart');
		}

		if (!isset($this->request->post['theme_'.$this->_moduleSysName().'_image_location_width']) || !$this->request->post['theme_'.$this->_moduleSysName().'_image_location_width'] || !$this->request->post['theme_'.$this->_moduleSysName().'_image_location_height']) {
			$this->error['image_location'] = $this->language->get('error_image_location');
		}

		return !$this->error;
	}

	// Api

	private function updateColors()
	{
		/* Компилируем цвета BEGIN */

		// Текущие значения
		$sysname = $this->_moduleSysName();

		$this->load->model('setting/setting');
		$data = array();
		if (isset($this->request->get['store_id'])) {
			$data = $this->model_setting_setting->getSetting('theme_'.$this->_moduleSysName(), $this->request->get['store_id']);
		}

		$filenames = array(
			1 => DIR_CATALOG . "view/theme/".$this->_moduleSysName()."/stylesheet/colors_vars.css",
			2 => DIR_CATALOG . "view/theme/".$this->_moduleSysName()."_mob/stylesheet/colors_vars.css",
		);
		$directories = array(
			1 => DIR_CATALOG . "view/theme/".$this->_moduleSysName()."/min",
			2 => DIR_CATALOG . "view/theme/".$this->_moduleSysName()."_mob/min",
		);

		foreach ($directories as $directory){
			$this->runCleaner($directory);
		}

		foreach ($filenames as $filename){
			$color_vars = file_get_contents($filename);
			$color_vars = str_replace('---','',$color_vars); // Для любителей писать комментарии вида /*--- ---*/

			$re = '/(--([^:]*):[^\n]*;)/i';
			preg_match_all($re, $color_vars, $matches, PREG_SET_ORDER, 0);
			$replaces = array();
			foreach ($matches as $match){
				if(isset($data['theme_'.$sysname."_".$match[2]])){
					$replaces[] = array(
						'find' => $match[1],
						'replace' => '--'.$match[2].": ".$data['theme_'.$sysname."_".$match[2]].";",
					);
				}
			}
			foreach ($replaces as $r){
				$color_vars = str_replace($r['find'],$r['replace'],$color_vars);
			}
			$this->log('Обновили '. count($replaces) . "цветовых значений");
			file_put_contents($filename,$color_vars);
			/* Компилируем цвета END */
		}
	}

	public function compileScss()
	{
		$json = [];
		try {
			SassCompiler::run(
					DIR_CATALOG . "view/theme/".$this->_moduleSysName()."/stylesheet/",
					DIR_CATALOG . "view/theme/".$this->_moduleSysName()."/stylesheet/",
				"scss_formatter_compressed");

			SassCompiler::run(
				DIR_CATALOG . "view/theme/".$this->_moduleSysName()."_mob/stylesheet/",
				DIR_CATALOG . "view/theme/".$this->_moduleSysName()."_mob/stylesheet/",
				"scss_formatter_compressed");


			$json['compile'] = 'all';
			$json['result'] = true;

			$this->response->setOutput(json_encode($json));

		} catch (\Exception $e) {

			$this->log($e->getMessage());

			$this->response->setOutput(json_encode(['result' => false]));
		}


	}

	private function runCleaner($folderName)
	{
		if (is_dir($folderName)) {
			foreach (new DirectoryIterator($folderName) as $fileInfo) {
				if ($fileInfo->isDot()) {
					continue;
				}
				if ($fileInfo->isFile()) {
					unlink($fileInfo->getRealPath());
				}
			}
		}
		file_put_contents($folderName."/index.html",":)");
		return true;
	}
}
