<?php

require_once( DIR_SYSTEM . "/engine/neoseo_controller.php");

class ControllerToolNeoSeoFilterPageGenerator extends NeoSeoController
{

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_moduleSysName = "neoseo_filter_page_generator";
		$this->_module_code = 'neoseo_firestore_free';
		$this->_logFile = $this->_moduleSysName . ".log";
		$this->debug = $this->config->get($this->_moduleSysName . "_debug") == 1;
	}

	public function jsonGeneratePage()
	{
		$json = array(
			'offset' => '',
			'limit' => '',
			'total' => ''
		);
		$this->load->model('tool/' . $this->_moduleSysName());

		$validate = $this->model_tool_neoseo_filter_page_generator->validate();

		if ($validate['error'] == true) {
			$json['error'] = $validate['error_text'];
			$this->response->setOutput(json_encode($json));
			return;
		}

		if (!isset($this->request->get['rule_id'])) {
			$json['error'] = 'Не найден rule_id';
			$this->response->setOutput(json_encode($json));
			return false;
		}

		$rule_id = (int) $this->request->get['rule_id'];

		$this->load->model('catalog/' . $this->_moduleSysName());

		$rule_info = $this->model_catalog_neoseo_filter_page_generator->getRule($rule_id);

		if (!$rule_info) {
			$json['error'] = "Правило не найдено в базе";
			$this->response->setOutput(json_encode($json));
			return;
		}

		if ($rule_info['status'] != 1) {
			$json['error'] = "Правило отключено";
			$this->response->setOutput(json_encode($json));
			return;
		}

		if (!$rule_info['options']) {
			$json['error'] = "Правило не содержит опций";
			$this->response->setOutput(json_encode($json));
			return;
		}


		$limit = $this->config->get($this->_moduleSysName() . '_limit_records');
		$limit = $limit ? $limit : 100;

		$offset = 0;
		if (isset($this->request->get['offset'])) {
			$offset = (int) $this->request->get['offset'];
		}

		$this->log("Начало формирования посадочных страниц для правила с #{$rule_info['rule_id']}, limit: {$limit}, offset: {$offset} ");
		$this->log('=====================================================================');

		$this->load->model('catalog/neoseo_filter');
		$multi_options = $this->model_catalog_neoseo_filter->explodeFilterParam($rule_info['options']);

		$options = array();
		foreach ($multi_options as $option_values) {
			foreach ($option_values as $option_value)
				$options[] = $option_value;
		}

		$filter_data = array(
			'category_id' => $rule_info['category_id'],
			'options' => $options,
			'start' => $offset,
			'limit' => $limit,
		);

		if ($offset == 0) {
			$this->session->data['main_total'] = (int) $this->model_tool_neoseo_filter_page_generator->getTotalRecord($filter_data);
			$this->log("Всего записей {$this->session->data['main_total']}");
		}

		$records = $this->model_tool_neoseo_filter_page_generator->getRecords($filter_data);

		if (!$this->session->data['main_total'] && !$records) {
			$json['error'] = "Нет данных для генерации";
			$this->response->setOutput(json_encode($json));
			return;
		}

		$idx = 0;
		foreach ($records as $product_id => $record) {
			$this->model_tool_neoseo_filter_page_generator->generatePagesByRule($rule_info, $record);
			$idx++;
		}

		if (!isset($this->session->data['count_records'])) {
			$this->session->data['count_records'] = $this->session->data['main_total'];
		}

		$this->session->data['count_records'] = $this->session->data['count_records'] - count($records);
		$this->log("Осталось {$this->session->data['count_records']} запись(-ей).");

		$json = array(
			'offset' => $offset + $idx,
			'limit' => $limit,
			'total' => $this->session->data['main_total']
		);

		$this->response->setOutput(json_encode($json));
	}

	public function jsonGenerateRules()
	{
		$json = array(
			'offset' => '',
			'limit' => '',
			'total' => ''
		);

		if ($this->config->get($this->_moduleSysName() . '_status') != 1) {
			$json['error'] = 'Модуль отключен!';
			$this->response->setOutput(json_encode($json));
			return;
		}

		$this->log('=================================================');
		$this->log('Начало формирования списка правил для генератора.');
		$this->log('=================================================');

		$limit = $this->config->get($this->_moduleSysName() . '_limit_categories');
		$limit = $limit ? $limit : 50;

		$offset = 0;
		if (isset($this->request->get['offset'])) {
			$offset = (int) $this->request->get['offset'];
		}

		$this->load->model('tool/' . $this->_moduleSysName());
		$this->load->model('catalog/category');

		if ($offset == 0) {
			$this->session->data['main_total'] = (int) $this->model_catalog_category->getTotalCategories();
		}

		$filter_data = array(
			'start' => $offset,
			'limit' => $limit,
		);

		$categories = $this->model_catalog_category->getCategories($filter_data);

		if (empty($categories) || $categories == '') {
			$json['error'] = 'Не найдены категории для генерации!';
			$this->response->setOutput(json_encode($json));
			return;
		}

		$idx = 0;
		foreach ($categories as $key => $category) {
			$this->model_tool_neoseo_filter_page_generator->generateRule($category['category_id']);
			$idx++;
		}

		$json = array(
			'offset' => $offset + $idx,
			'limit' => $limit,
			'total' => $this->session->data['main_total']
		);

		$this->log('=================================================');
		$this->log('Формирование правил для генератора завершено.');
		$this->log('=================================================');

		$this->response->setOutput(json_encode($json));
	}

	/* Оставим до лучших времен
	  public function jsonGeneratePageSelectedRule()
	  {
	  $json = array(
	  'offset' => '',
	  'limit' => '',
	  'total' => ''
	  );

	  if ($this->config->get($this->_moduleSysName() . '_status') != 1) {
	  $json['error'] = 'Модуль отключен!';
	  $this->response->setOutput(json_encode($json));
	  return;
	  }

	  if (!isset($this->request->get['selected']) || !$selected = explode(',', $this->request->get['selected'])) {
	  $json['error'] = 'Для генерации посадочных страниц должны быть выбраны правила!';
	  $this->response->setOutput(json_encode($json));
	  return false;
	  }

	  $this->load->model('tool/' . $this->_moduleSysName());

	  foreach ($selected as $idx => $rule_id) {
	  $this->model_tool_neoseo_filter_page_generator->generatePagesByRule($rule_id);
	  }

	  $offset = 0;
	  $count = count($selected);

	  $json = array(
	  'offset' => $offset + $idx + 1,
	  'limit' => $count,
	  'total' => $count
	  );

	  $this->response->setOutput(json_encode($json));
	  }

	  public function jsonGeneratePageAllRule()
	  {
	  $json = array(
	  'offset' => '',
	  'limit' => '',
	  'total' => ''
	  );

	  if ($this->config->get($this->_moduleSysName() . '_status') != 1) {
	  $json['error'] = 'Модуль отключен!';
	  $this->response->setOutput(json_encode($json));
	  return;
	  }

	  $limit = $this->config->get($this->_moduleSysName() . '_limit_records');
	  $limit = $limit ? $limit : 100;

	  $offset = 0;
	  if (isset($this->request->get['offset'])) {
	  $offset = (int) $this->request->get['offset'];
	  }

	  $this->load->model('tool/' . $this->_moduleSysName());
	  $this->load->model('catalog/' . $this->_moduleSysName());

	  $this->load->model('catalog/product');

	  $filter_data = array(
	  'status' => 1,
	  );

	  if ($offset == 0) {
	  $this->session->data['main_total'] = (int) $this->model_catalog_neoseo_filter_page_generator->getTotalRules($filter_data);
	  }

	  $filter_data = array(
	  'start' => $offset,
	  'limit' => $limit,
	  'status' => 1,
	  );

	  $items = $this->model_catalog_neoseo_filter_page_generator->getRules($filter_data);

	  if (empty($items) || $items == '') {
	  $json['error'] = 'Не найдены правила для генерации!';
	  $this->response->setOutput(json_encode($json));
	  return;
	  }

	  foreach ($items as $idx => $item) {
	  $this->model_tool_neoseo_filter_page_generator->generatePagesByRule($item['rule_id']);
	  }

	  $json = array(
	  'offset' => $offset + $idx + 1,
	  'limit' => $limit,
	  'total' => $this->session->data['main_total']
	  );

	  $this->response->setOutput(json_encode($json));
	  }

	 */
}
