<?php

require_once( DIR_SYSTEM . '/engine/neoseo_controller.php');

class ControllerExtensionModuleNeoSeoSlideshow extends NeoSeoController
{

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_moduleSysName = "neoseo_slideshow";
		$this->_module_code = "neoseo_firestore_free";
		$this->_modulePostfix = ""; // Постфикс для разных типов модуля, поэтому переходим на испольлзование $this->_moduleSysName()
		$this->_logFile = $this->_moduleSysName() . ".log";
		$this->debug = $this->config->get($this->_moduleSysName() . "_debug") == 1;
	}

	public function index($setting)
	{
		static $module = 0;

		if (isset($setting['title'][$this->config->get('config_language_id')])) {
			$data['heading_title'] = $setting['title'][$this->config->get('config_language_id')];
		} else {
			$data['heading_title'] = false;
		}

		$this->load->model('design/banner');
		$this->load->model('tool/image');

		$template = 'default';

		if ($setting['template'] != $template && file_exists(DIR_TEMPLATE . $this->config->get('config_theme') . '/template/extension/module/' . $this->_moduleSysName() . '_' . $setting['template'] . '.twig')) {
			$template = $setting['template'];
		}

		$data['banners'] = array();

		$cache_key = $this->_moduleSysName() . '1_' . $module . '_' . $this->config->get('config_language_id') . "_" . $data['heading_title'] . "_" . $setting['template'];
		$results = $this->cache->get($cache_key);
		if (!$results) {
			$results = $this->model_design_banner->getBanner($setting['banner']);
			$this->cache->set($cache_key, $results);
		}
		//print_r($setting);exit;
		if (!isset($setting['width']) || $setting['width'] <= 0) {
			$width = 130;
		} else {
			$width = $setting['width'];
		}
		if (!isset($setting['height']) || $setting['height'] <= 0) {
			$height = 100;
		} else {
			$height = $setting['height'];
		}
		if($this->config->is_mobile()) {
			$width = ceil($width / 3);
			$height = ceil($height / 3);
		}
		if (!isset($setting['width2']) || $setting['width2'] <= 0) {
			$width2 = 130;
		} else {
			$width2 = $setting['width2'];
		}
		if (!isset($setting['height2']) || $setting['height2'] <= 0) {
			$height2 = 100;
		} else {
			$height2 = $setting['height2'];
		}

		foreach ($results as $result) {
			if (is_file(DIR_IMAGE . $result['image'])) {
				$data['banners'][] = array(
					'title' => $result['title'],
					'link' => $result['link'],
					'image' => $this->model_tool_image->resize($result['image'], $width, $height)
				);
			}
		}

		$data['banners2'] = array();
		if ($setting['banner2']) {
			$cache_key = $this->_moduleSysName() . '2_' . $module . '_' . $this->config->get('config_language_id');
			$results = $this->cache->get($cache_key);
			if (!$results) {
				$results = $this->model_design_banner->getBanner($setting['banner2']);
				$this->cache->set($cache_key, $results);
			}

			foreach ($results as $result) {
				if (is_file(DIR_IMAGE . $result['image'])) {
					$data['banners2'][] = array(
						'title' => $result['title'],
						'link' => $result['link'],
						'image' => $this->model_tool_image->resize($result['image'], $width2, $height2)
					);
				}
			}
		}

        $data['slide_width'] = $width;
        $data['slide_height'] = $height;

        $data['banner_width'] = $width2;
        $data['banner_height'] = $height2;

		$data['module'] = $module++;


		return $this->load->view('extension/module/' . $this->_moduleSysName() . '_' . $template, $data);
	}

}
