<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get form input values
    $sender_email = $_POST['sender_email'];
    $sender_name = $_POST['sender_name'];
    $subject = $_POST['subject'];
    $message = $_POST['message'];
    $recipients = $_POST['recipients'];

    // Prepare recipients (emails inputted one per line)
    $recipient_list = explode("\n", $recipients); // Split by line breaks
    $recipient_list = array_map('trim', $recipient_list); // Clean any extra spaces

    // Filter out any empty or invalid email addresses
    $recipient_list = array_filter($recipient_list, function($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL); // Validate each email
    });
    $recipient_list = array_values($recipient_list); // Re-index the array

    // Set headers for HTML email
    $headers = "From: $sender_name <$sender_email>\r\n";
    $headers .= "Reply-To: $sender_email\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

    // Initialize error variables
    $sent_count = 0;
    $failed_count = 0;
    $error_messages = [];

    // Loop through each recipient and send an individual email
    $line_number = 0; // Line counter to display each email status
    foreach ($recipient_list as $recipient) {
        // Display the line number in blue
        echo "<span style='color: blue;'>Line $line_number:</span> Sending mail to <strong>$recipient</strong>....... ";

        if (@mail($recipient, $subject, $message, $headers)) {
            // Display OK in green if email is sent successfully
            echo "<span style='color: green;'>OK</span><br/>";
            $sent_count++;
        } else {
            // Display Failed in red if email sending fails
            echo "<span style='color: red;'>Failed</span><br/>";
            $failed_count++;
            $error_messages[] = "Failed to send email to: $recipient";
        }

        // Increment line number for each recipient
        $line_number++;
    }

    // Provide feedback on how many emails were successfully sent
    echo "<br/>$sent_count email(s) sent successfully!<br/>";
    if ($failed_count > 0) {
        echo "$failed_count email(s) failed to send.<br/>";
        echo "Error Details:<br/>";
        foreach ($error_messages as $error) {
            echo $error . "<br/>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Send HTML Email</title>
    <style>
        /* Basic Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f7f7f7;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .container {
            background-color: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            width: 500px;
        }

        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }

        form {
            display: flex;
            flex-direction: column;
        }

        label {
            font-size: 14px;
            margin-bottom: 5px;
            color: #555;
        }

        input, textarea {
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            width: 100%;
        }

        textarea {
            height: 150px;
        }

        button {
            padding: 10px;
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
        }

        button:hover {
            background-color: #45a049;
        }

        .input-large {
            height: 150px;
        }

        .message {
            font-size: 14px;
            color: #333;
            text-align: center;
            margin-top: 20px;
        }

        .status {
            font-size: 14px;
            color: #333;
            white-space: pre-wrap;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Send HTML Email</h2>

    <form action="" method="POST">
        <label for="sender_email">Sender Email:</label>
        <input type="email" id="sender_email" name="sender_email" required>

        <label for="sender_name">Sender Name:</label>
        <input type="text" id="sender_name" name="sender_name" required>

        <label for="subject">Subject:</label>
        <input type="text" id="subject" name="subject" required>

        <label for="message">HTML Message:</label>
        <textarea id="message" name="message" required></textarea>

        <label for="recipients">Recipient Emails (one per line):</label>
        <textarea id="recipients" name="recipients" class="input-large" required></textarea>

        <button type="submit">Send Email</button>
    </form>

    <?php if ($_SERVER["REQUEST_METHOD"] == "POST"): ?>
        <div class="status">
            <?php 
                // Show feedback after sending emails
                if ($sent_count > 0) {
                    echo "$sent_count email(s) sent successfully!<br/>";
                } else {
                    echo "There was an error sending the emails.";
                }

                // Display error messages if some emails failed
                if ($failed_count > 0) {
                    echo "$failed_count email(s) failed.<br/>";
                    foreach ($error_messages as $error) {
                        echo $error . "<br/>";
                    }
                }
            ?>
        </div>
    <?php endif; ?>
</div>

</body>
</html>
