<?php
class ControllerModuleLittleBanner extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('module/little_banner');
        $this->load->model('localisation/language');
        $this->load->model('tool/image');
        Slide::$toolImage = $this->model_tool_image;
        Slide::$language = $this->language;

        $data['languages'] = $this->model_localisation_language->getLanguages();
      
        //var_dump($data['languages']);

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('extension/module');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
            if (!isset($this->request->get['module_id'])) {
                $this->model_extension_module->addModule('little_banner', $this->request->post);
            } else {
                $this->model_extension_module->editModule($this->request->get['module_id'], $this->request->post);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_edit'] = $this->language->get('text_edit');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        $data['entry_name'] = $this->language->get('entry_name');
        $data['entry_title'] = $this->language->get('entry_title');
        $data['entry_button_title'] = $this->language->get('entry_button_title');
        $data['entry_button_link'] = $this->language->get('entry_button_link');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_image'] = $this->language->get('entry_image');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');
        $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

        $data['slides'] = ['slide1' => new Slide('slide1', $data['languages']), 'slide2' => new Slide('slide2', $data['languages']), 'slide3' => new Slide('slide3', $data['languages']), 'slide4' => new Slide('slide4', $data['languages'])];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = '';
        }


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_module'),
            'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL')
        );

        if (!isset($this->request->get['module_id'])) {
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('module/little_banner', 'token=' . $this->session->data['token'], 'SSL')
            );
        } else {
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('module/little_banner', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], 'SSL')
            );
        }

        if (!isset($this->request->get['module_id'])) {
            $data['action'] = $this->url->link('module/little_banner', 'token=' . $this->session->data['token'], 'SSL');
        } else {
            $data['action'] = $this->url->link('module/little_banner', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], 'SSL');
        }

        $data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

        if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $module_info = $this->model_extension_module->getModule($this->request->get['module_id']);
        }

        if (isset($this->request->post['name'])) {
            $data['name'] = $this->request->post['name'];
        } elseif (!empty($module_info)) {
            $data['name'] = $module_info['name'];
        } else {
            $data['name'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($module_info)) {
            $data['status'] = $module_info['status'];
        } else {
            $data['status'] = '';
        }


        foreach ($data['slides'] as $slide) {
            if (isset($this->request->post[$slide->name])) {
                $slide->setValues($this->request->post[$slide->name]);
            } elseif (!empty($module_info)) {
                $slide->setValues($module_info[$slide->name]);
            }
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('module/little_banner.tpl', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'module/little_banner')) {
            $this->error['warning'] = $this->language->get('error_permission');
            return false;
        }
        if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
            $this->error['name'] = $this->language->get('error_name');
            return false;
        }
        return true;
    }

}
class Slide {
    public static $toolImage = NULL;
    public static $language = NULL;

    /**
     *  internal name
     * @var string
     */
    public $name;

    /**
     *  tab title
     * @var string
     */
    public $heading;
    public $thumb = null;
    public $titles = [];
    public $titlesEntries = [];
    public $buttonTitles = [];
    public $buttonTitlesEntries = [];
    public $buttonLinks = [];
    public $buttonLinksEntries = [];
    public $images = [];
    public $imagesEntries = [];
    public $imagesThumbs = [];


    public function __construct($name, $languages) {
        $this->name = $name;
        $this->heading = self::$language->get('slide_' . $name);
        $this->imageEntry = $name . '[image]';
        foreach ($languages as $lang) {
            $code = $lang['code'];
            $this->titles[$code] = '';
            $this->titlesEntries[$code] = $name . '[title][' . $code . ']';
            $this->buttonTitles[$code] = '';
            $this->buttonTitlesEntries[$code] = $name . '[button_title][' . $code . ']';
            $this->buttonLinks[$code] = '';
            $this->buttonLinksEntries[$code] = $name . '[button_link][' . $code . ']';
            $this->images[$code] = '';
            $this->imagesEntries[$code] = $name . '[image][' . $code . ']';
        }
    }

    public function setValues($values) {
        if (isset($values['title'])) {
            $this->titles = $values['title'];
        }
        if (isset($values['button_title'])) {
            $this->buttonTitles = $values['button_title'];
        }
        if (isset($values['button_link'])) {
            $this->buttonLinks = $values['button_link'];
        }
        if (isset($values['image'])) {
            $this->images = $values['image'];
        }
        foreach($this->images as $key => $si) {
            if (is_file(DIR_IMAGE . $si)) {
                $this->imagesThumbs[$key] = self::$toolImage->resize($si, 100, 100);
            } else {
                $this->imagesThumbs[$key] = self::$toolImage->resize('no_image.png', 100, 100);
            }
        }
    }

}