<?php
class ControllerCommonHeader extends Controller {
	public function index() {
		// Analytics
		$this->load->model('extension/extension');

		$data['analytics'] = array();

		$analytics = $this->model_extension_extension->getExtensions('analytics');

		foreach ($analytics as $analytic) {
			if ($this->config->get($analytic['code'] . '_status')) {
				$data['analytics'][] = $this->load->controller('analytics/' . $analytic['code']);
			}
		}

		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}

		if (is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->document->addLink($server . 'image/' . $this->config->get('config_icon'), 'icon');
		}

		$data['title'] = $this->document->getTitle();

                
                //Microdata_Plugin_OCext - microdata
                $this->load->model('feed/ocext_feed_generator_google');
                $microdataseourlgenerator = $this->model_feed_ocext_feed_generator_google->getScript();
                if($microdataseourlgenerator){
                    $data['analytics'][] = $microdataseourlgenerator;
                }
                //end Microdata_Plugin_OCext - microdata



		$data['base'] = $server;
		$data['description'] = $this->document->getDescription();
		$data['keywords'] = $this->document->getKeywords();
		$data['links'] = $this->document->getLinks();
		$data['styles'] = $this->document->getStyles();
		$data['scripts'] = $this->document->getScripts();
		$data['lang'] = $this->language->get('code');
		$data['direction'] = $this->language->get('direction');

		$data['name'] = $this->config->get('config_name');
		$data['alter_lang'] = $this->getAlterLanguageLinks($this->document->getLinks());

		if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
			$data['logo'] = $server . 'image/' . $this->config->get('config_logo');
		} else {
			$data['logo'] = '';
		}

		$this->load->language('common/header');

		$data['text_home'] = $this->language->get('text_home');

		// Wishlist
		if ($this->customer->isLogged()) {
			$this->load->model('account/wishlist');

			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), $this->model_account_wishlist->getTotalWishlist());
		} else {
			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
		}

		$data['text_shopping_cart'] = $this->language->get('text_shopping_cart');
		$data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('account/account', '', 'SSL'), $this->customer->getFirstName(), $this->url->link('account/logout', '', 'SSL'));

		$data['text_account'] = $this->language->get('text_account');
		$data['text_register'] = $this->language->get('text_register');
		$data['text_login'] = $this->language->get('text_login');
		$data['text_order'] = $this->language->get('text_order');
		$data['text_transaction'] = $this->language->get('text_transaction');
		$data['text_download'] = $this->language->get('text_download');
		$data['text_logout'] = $this->language->get('text_logout');
		$data['text_checkout'] = $this->language->get('text_checkout');
		$data['text_category'] = $this->language->get('text_category');
		$data['text_all'] = $this->language->get('text_all');

		$data['home'] = $this->url->link('common/home');
		$data['wishlist'] = $this->url->link('account/wishlist', '', 'SSL');
		$data['logged'] = $this->customer->isLogged();
		$data['account'] = $this->url->link('account/account', '', 'SSL');
		$data['register'] = $this->url->link('account/register', '', 'SSL');
		$data['login'] = $this->url->link('account/login', '', 'SSL');
		$data['order'] = $this->url->link('account/order', '', 'SSL');
		$data['transaction'] = $this->url->link('account/transaction', '', 'SSL');
		$data['download'] = $this->url->link('account/download', '', 'SSL');
		$data['logout'] = $this->url->link('account/logout', '', 'SSL');
		$data['shopping_cart'] = $this->url->link('checkout/cart');
		$data['checkout'] = $this->url->link('checkout/checkout', '', 'SSL');
		$data['contact'] = $this->url->link('information/contact');
		$data['telephone'] = $this->config->get('config_telephone');

		$status = true;

		if (isset($this->request->server['HTTP_USER_AGENT'])) {
			$robots = explode("\n", str_replace(array("\r\n", "\r"), "\n", trim($this->config->get('config_robots'))));

			foreach ($robots as $robot) {
				if ($robot && strpos($this->request->server['HTTP_USER_AGENT'], trim($robot)) !== false) {
					$status = false;

					break;
				}
			}
		}

		// Menu
		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$data['categories'] = array();

		$categories = $this->model_catalog_category->getCategories(0);

		foreach ($categories as $category) {
			if ($category['top']) {
				// Level 2
				$children_data = array();

				$children = $this->model_catalog_category->getCategories($category['category_id']);

				foreach ($children as $child) {
					$filter_data = array(
						'filter_category_id'  => $child['category_id'],
						'filter_sub_category' => true
					);

					$children_data[] = array(
						'name'  => $child['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''),
						'href'  => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id'])
					);
				}

				// Level 1
				$data['categories'][] = array(
					'name'     => $category['name'],
					'children' => $children_data,
					'column'   => $category['column'] ? $category['column'] : 1,
					'href'     => $this->url->link('product/category', 'path=' . $category['category_id'])
				);
			}
		}

		
			if($this->config->get('megamenu_status')=="1")
			{
			
		$this->language->load('module/megamenu');
		$this->load->model('module/megamenu');
		$this->load->model('catalog/category');
		$this->load->model('catalog/product');
		
		
	 
		$data['heading_title'] = $this->language->get('heading_title');		
	
		$data['items']=array();
		$tmp_items= $this->model_module_megamenu->getItems();
		if(count($tmp_items))
		{
			foreach($tmp_items as $item){
			if($item['menu_type']=="category")	{
			$data['items'][]=$this->model_module_megamenu->parseCategory($item);
			}
			if($item['menu_type']=="html")	{
			$data['items'][]=$this->model_module_megamenu->parseHtml($item);
			}
            if($item['menu_type']=="link")	{
			$data['items'][]=$this->model_module_megamenu->parseLink($item);
			}
			if($item['menu_type']=="manufacturer")	{
			$data['items'][]=$this->model_module_megamenu->parseManufacturer($item);
			}
			if($item['menu_type']=="information")	{
			$data['items'][]=$this->model_module_megamenu->parseInformation($item);
			}
			if($item['menu_type']=="product")	{
			$data['items'][]=$this->model_module_megamenu->parseProduct($item);
			}	
			if($item['menu_type']=="auth" && !$this->customer->isLogged())	{
			$data['items'][]=$this->model_module_megamenu->parseAuth($item);
			}
				
				
			}
			
			
			
		}
		
		//auth
		$this->load->language('account/login');
		$this->load->language('module/megamenu');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_password'] = $this->language->get('entry_password');
		$data['text_forgotten'] = $this->language->get('text_forgotten');
		$data['text_register'] = $this->language->get('text_register');
		$data['menu_title'] = $this->language->get('menu_title');
		
		$data['button_login'] = $this->language->get('button_login');
		$data['action'] = $this->url->link('account/login', '', 'SSL');
		$data['email'] = "";
		$data['register'] = $this->url->link('account/register', '', 'SSL');
		$data['forgotten'] = $this->url->link('account/forgotten', '', 'SSL');
		$data['use_megamenu']=true;
	    }
		else
		$data['use_megamenu']=false;
		
	    $data['language'] = $this->load->controller('common/language');
			
		$data['currency'] = $this->load->controller('common/currency');
		$data['search'] = $this->load->controller('common/search');
		$data['cart'] = $this->load->controller('common/cart');

		// For page specific css
		if (isset($this->request->get['route'])) {
			if (isset($this->request->get['product_id'])) {
				$class = '-' . $this->request->get['product_id'];
			} elseif (isset($this->request->get['path'])) {
				$class = '-' . $this->request->get['path'];
			} elseif (isset($this->request->get['manufacturer_id'])) {
				$class = '-' . $this->request->get['manufacturer_id'];
			} else {
				$class = '';
			}

			$data['class'] = str_replace('/', '-', $this->request->get['route']) . $class;
		} else {
			$data['class'] = 'common-home';
		}

		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/header.tpl')) {
			return $this->load->view($this->config->get('config_template') . '/template/common/header.tpl', $data);
		} else {
			return $this->load->view('default/template/common/header.tpl', $data);
		}
	}
	
	protected function getAlterLanguageLinks($links) {
		$result = array();
		if ($this->config->get('config_seo_url')) {
			foreach($links as $link) {
				if($link['rel']=='canonical') {
					$url=$link['href'];
					$schema = parse_url($url,PHP_URL_SCHEME);
					$server = strtolower($schema)=='https' ? HTTPS_SERVER : HTTP_SERVER; 
					$cur_lang = substr($url, strlen($server),2);
					$query = substr($url, strlen($server)+2);
					$this->load->model('localisation/language');
					$languages = $this->model_localisation_language->getLanguages();
					$active_langs = array();
					foreach($languages as $lang) {
						if($lang['status']) {
							$active_langs[]=$lang['code'];
						} 
					}
					if(in_array($cur_lang, $active_langs)) {
						foreach($active_langs as $lang) {
							$result[$lang] = $server.$lang.($query ? $query : '');
						}
					}
				}
			}
		}
		return $result;
	}
}
